/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.*;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class MoveClassUI implements RefactoringUI, RefactoringUIBypass {
    
    private JavaDataObject javaObject;    
    private Resource resource;
    private JavaClass mainSourceClass;
    private MoveClassPanel panel;
    private MoveClassRefactoring refactoring;
    private String targetPkgName = "";
    private boolean disable;
    private JavaClass clazz = null;
    private FileObject targetFolder;
    private PasteType pasteType;
    
    static final String getString(String key) {
        return NbBundle.getMessage(MoveClassUI.class, key);
    }
    
    public MoveClassUI (JavaClass sourceClass) {
        resource = (Resource) sourceClass.getResource();
        DataObject ob =  JavaMetamodel.getManager().getDataObject(resource);
        if (ob instanceof JavaDataObject)
            javaObject = (JavaDataObject) ob;
        clazz = sourceClass;
        findMainClass ();
    }
    
    public MoveClassUI (JavaDataObject javaObject) {
        this(javaObject, null, null);
    }
    
    public MoveClassUI (JavaDataObject javaObject, FileObject targetFolder, PasteType pasteType) {
        this.disable = targetFolder != null ;
        this.targetFolder = targetFolder;
        this.javaObject = javaObject;
        this.pasteType = pasteType;
        resource = JavaModel.getResource(javaObject.getPrimaryFile());
        findMainClass ();
    }
    
    public String getName() {
        return getString ("LBL_MoveClass");
    }
     
    public String getDescription() {
        if (mainSourceClass == null) {
            return new MessageFormat(getString("DSC_MoveClass")).format(
                    new Object[] {javaObject.getName(), packageName()}
            );
        } else {
            if (mainSourceClass.isValid()) {
                return new MessageFormat(getString("DSC_MoveClass")).format(
                        new Object[] {mainSourceClass.getName(), packageName()}
                );
            } else return "";//NOI18N
        }
    }
    
    public boolean isQuery() {
        return false;
    }
        
    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (panel == null) {
            String pkgName = null;
            if (targetFolder != null) {
                ClassPath cp = ClassPath.getClassPath(targetFolder, ClassPath.SOURCE);
                if (cp != null)
                    pkgName = cp.getResourceName(targetFolder, '.', false);
            }
            
            panel = new MoveClassPanel (parent, pkgName != null ? pkgName: getResPackageName(mainSourceClass), 
                    new MessageFormat(getString("LBL_MoveClassNamed")).format (
                    new Object[] {mainSourceClass==null?"":mainSourceClass.getName()}
                ),
                targetFolder != null ? targetFolder : (javaObject != null ? javaObject.getPrimaryFile(): null)
            );
            panel.setCombosEnabled(!disable);
        }
        return panel;
    }
    
    private static String getResPackageName(JavaClass cl) {
        if (cl==null)
            return ""; 
        Resource res = (Resource) cl.refImmediateComposite();
        String name = res.getName();
        int index = name.lastIndexOf('/');
        if ( index == -1 )
            return "";
        return name.substring(0, index).replace('/','.');
    }

    private void findMainClass () {
        mainSourceClass = null;
        java.util.List list = resource.getClassifiers();
        int size = list.size ();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            mainSourceClass = (JavaClass) list.get (0);
            return;
        }
                
        String resName = resource.getName();
        int index_1 = resName.lastIndexOf ('/');
        int index_2 = resName.indexOf ('.');
        String mainClassName = null;
        if (index_2 > -1) {
            mainClassName = resName.substring (index_1 + 1, index_2);
        }
        
        Iterator iter = list.iterator ();        
        for (int x = 0; x < size; x++) {
            JavaClass jc = (JavaClass) iter.next ();
            if ((mainClassName != null) && mainClassName.equals (jc.getName ())) {
                mainSourceClass = jc;
                return;
            }
            if ((jc.getModifiers() & Modifier.PUBLIC) > 0)
                mainSourceClass = jc;
        }
        if (mainSourceClass == null) {
            mainSourceClass = (JavaClass) list.get (0);
        }        
    }
    
    private String packageName () {
        return targetPkgName.trim().length() == 0 ? getString ("LBL_DefaultPackage") : targetPkgName.trim ();
    }
    
    private Problem setParameters(boolean checkOnly) {
        if (panel==null)
            return null;
        targetPkgName = panel.getPackageName ();

        refactoring.setTargetPackageName(targetPkgName);
        refactoring.setTargetClassPathRoot(panel.getRootFolder());
        if (checkOnly) {
            return refactoring.fastCheckParameters();
        } else {
            return refactoring.checkParameters();
        }
    }
    
    public Problem checkParameters() {
        return setParameters(true);
    }
    
    public Problem setParameters() {
        return setParameters(false);
    }
    
    public AbstractRefactoring getRefactoring() {
        if (refactoring == null) {
            List list = new LinkedList();
            list.add(resource);
            if (clazz != null) {
                refactoring = new MoveClassRefactoring (clazz);
            } else {
                refactoring = new MoveClassRefactoring (list);
            }
        }
        return refactoring;
    }
    
    public boolean hasParameters() {
        return true;
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveClassUI.class);
    }

    public boolean isRefactoringBypassRequired() {
        return !panel.isUpdateReferences();
    }
    public void doRefactoringBypass() throws IOException {
        pasteType.paste();
    }
}
