/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JEditorPane;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.java.JavaDataObject;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;

public class MoveClassAction extends AbstractRefactoringAction {        

    public MoveClassAction() {
        super (NbBundle.getMessage(MoveClassAction.class, "LBL_MoveClassAction"), null);
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    protected boolean enabled(Node[] activatedNodes) {
        if ((activatedNodes == null) || (activatedNodes.length < 1))
            return false;
                
        Lookup lkp = activatedNodes[0].getLookup();
        JavaDataObject javaObject = (JavaDataObject) lkp.lookup(JavaDataObject.class);
        
        if (javaObject != null)  
            if (!((JMManager) JMManager.getManager()).mergedCPContains(javaObject.getPrimaryFile()))
                return false;
        
        TopComponent activetc = TopComponent.getRegistry().getActivated();
        if (activetc instanceof CloneableEditorSupport.Pane) {
            JEditorPane pane=((CloneableEditorSupport.Pane)activetc).getEditorPane();
            if (pane!=null) {
                return javaObject instanceof JavaDataObject;
            }
        }

        Element elem = (Element) lkp.lookup(Element.class);
        if ((javaObject != null) && (elem == null))
            return true;
        if (!(elem instanceof JavaClass))
            return false;
        JavaClass clsElem = (JavaClass) elem;
        if (clsElem == null)
            return false;
        if (!clsElem.isValid())
            return false;
        if (clsElem.getDeclaringClass () != null)
            return false;
        return true;
    }
    
    protected RefactoringUI createRefactoringUI(Node[] nodes, org.netbeans.jmi.javamodel.Element selectedElement) {
        if (fromListener) {
            if (javaDataObjects.size() == 1 && javaDataObjects.iterator().next() instanceof JavaDataObject ) {
                return new MoveClassUI((JavaDataObject) javaDataObjects.iterator().next(), targetFolder, pasteType);
            } else {
                return new MoveClassesUI(javaDataObjects, targetFolder, pasteType);
            }
        }
        
        if (selectedElement != null) {
            if (selectedElement instanceof ElementReference) {
                selectedElement = ((ElementReference)selectedElement).getElement();
            }
            if (selectedElement instanceof JavaClass)
                return new MoveClassUI((JavaClass) selectedElement);
        }

        if (nodes.length>1) {
            return new MoveClassesUI(getJDOs(nodes)); 
        }
        
        JavaClass el = (JavaClass) nodes[0].getLookup().lookup(JavaClass.class);
        if (el != null && el.getDeclaringClass() == null)
            return new MoveClassUI (el);
        else
            return new MoveClassUI ((JavaDataObject) nodes [0].getCookie (JavaDataObject.class));
    }
    
    private boolean fromListener = false;
    private Set javaDataObjects;
    private FileObject targetFolder;
    private PasteType pasteType;
    
    public void performAction(final Set a, final FileObject targetFolder, final PasteType pt) {
        Runnable run = new Runnable() {
            public void run() {
                fromListener = true;
                javaDataObjects = a;
                MoveClassAction.this.targetFolder = targetFolder;
                MoveClassAction.this.pasteType = pt;
                MoveClassAction.super.performAction((Node []) null);
            }
        };
        JavaMetamodel.getManager().invokeAfterScanFinished(run, NbBundle.getMessage(MoveClassAction.class, "LBL_MoveClasses"));
    }
    
    public void performAction() {
        fromListener = false;
        super.performAction();
    }
    
    private Set getJDOs(Node[] nodes) {
        Set result = new HashSet(nodes.length);
        for (int i=0; i< nodes.length; i++) {
            JavaDataObject jdo = (JavaDataObject) nodes[i].getCookie(JavaDataObject.class);
            if (jdo!=null)
                result.add(jdo);
        }
        return result;
    }
}
