/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/** Action that invokes Extract Super Class refactoring.
 *
 * @author Martin Matula
 */
public class ExtractSuperClassAction extends AbstractRefactoringAction {
    
    /** Creates a new instance of ExtractSuperClassAction
     */
    public ExtractSuperClassAction() {
        super(NbBundle.getMessage(ExtractSuperClassAction.class, "LBL_ExtractSC_Action"), null); // NOI18N
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    protected RefactoringUI createRefactoringUI(Node[] nodes, Element selectedElement) {
        if (selectedElement == null) {
            // selected element is null -> action was invoked on nodes
            selectedElement = (Element) nodes[0].getLookup().lookup(Element.class);

            if (selectedElement == null) {
                // if the node does not have a java element associated with it
                // try of it has at least JavaDataObject associated
                Object ob = nodes[0].getCookie(JavaDataObject.class);
                if (ob != null) {
                    // if it does, take the resource correcponding to that
                    // JavaDataObject as Java element the action should be
                    // performed on
                    JavaDataObject o = (JavaDataObject) ob;
                    selectedElement = JavaModel.getResource(o.getPrimaryFile());
                }
            }
        }
        
        return new ExtractSuperClassRefactoringUI(selectedElement);
    }
    
    /** Method that determines whether this action is enabled for the active nodes.
     * @param activatedNodes Active nodes.
     * @return Boolean indicating whether the action is enabled.
     */
    protected boolean enabled(Node[] activatedNodes) {
        // if no nodes or more than one node are active, the action should be disabled
        if (activatedNodes.length != 1) return false;
        
        // the action should be enabled only if the selected node is associated
        // with the JavaDataObject
        DataObject dobj = (DataObject) activatedNodes[0].getCookie(DataObject.class);
        // check if the dataobject is instance of JavaDataObejct and that it represents a file
        // that is on the IDE classpath (belongs to one of open projects)
        if ((dobj instanceof JavaDataObject) && ((JMManager) JavaMetamodel.getManager()).mergedCPContains(dobj.getPrimaryFile())) {
            return true;
        } else {
            return false;
        }
    }
}
