/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.refactoring.ui;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ExtractMethodRefactoring;
import org.netbeans.modules.refactoring.api.ExtractMethodRefactoring.ParameterInfo;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author thurka
 */
public class ExtractMethodRefactoringUI  implements RefactoringUI {
    private ExtractMethodRefactoring refactoring;
    private ExtractMethodPanel panel;
    
    public ExtractMethodRefactoringUI(Element selectedElement,int startOffset,int endOffset) {
        refactoring = new ExtractMethodRefactoring(selectedElement==null ? null : selectedElement.getResource(),startOffset,endOffset);
    }

    public Problem setParameters() {
        captureParameters();
        return refactoring.checkParameters();
    }
    
    public Problem checkParameters() {
        captureParameters();
        return refactoring.fastCheckParameters();
    }

    public String getDescription() {
        return NbBundle.getMessage(ExtractMethodAction.class, "DSC_ExtractMethod"); // NOI18N
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ExtractMethodRefactoringUI.class.getName());
    }

    public String getName() {
        return NbBundle.getMessage(ExtractMethodAction.class, "LBL_ExtractMethod"); // NOI18N
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (panel == null) {
            parent.setPreviewEnabled(true);
            panel = new ExtractMethodPanel(refactoring, parent);
        }
        return panel;
    }

    public AbstractRefactoring getRefactoring() {
        return refactoring;
    }

    public boolean hasParameters() {
        return true;
    }

    public boolean isQuery() {
        return false;
    }

    private void captureParameters() {
        List data = (List) panel.getTableModel().getDataVector();
        ParameterInfo[] paramList = refactoring.getParamTable();
        int counter = 0;
        for (Iterator rowIt = data.iterator(); rowIt.hasNext(); ++counter) {
            List row = (List) rowIt.next();
            String name = (String) row.get(0);
            Variable var = (Variable) row.get(2);
            
            paramList[counter]=new ParameterInfo(var);
            paramList[counter].setName(name);
        }
        refactoring.setName(panel.getMethodName());
        refactoring.setModifier(panel.getModifier());
        refactoring.setStaticMod(panel.isStatic());
        
    }
}
