/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.refactoring.ui;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomas Hurka
 */
public class ExtractMethodAction extends AbstractRefactoringAction {
    
    public ExtractMethodAction() {
        super(NbBundle.getMessage(ExtractMethodAction.class, "LBL_ExtractMethod_Action"), null); // NOI18N
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }

    protected RefactoringUI createRefactoringUI(Node[] nodes, Element selectedElement) {
        return new ExtractMethodRefactoringUI(selectedElement,-1,-1);
    }
    
    protected RefactoringUI createRefactoringUI(Element selectedElement,int startOffset,int endOffset) {
        return new ExtractMethodRefactoringUI(selectedElement,startOffset,endOffset);
    }

    protected boolean enabled(Node[] activatedNodes) {
        // if no node or more than one node is active, the action should be disabled
        if (activatedNodes.length != 1) return false;
        
        // the action should be enabled only if all selected nodes are associated
        // with the same JavaDataObject (i.e. they are all declared in the same Java file)
        // so, let's get dataobject from the first activated node
        DataObject dobj = (DataObject) activatedNodes[0].getCookie(DataObject.class);
        // check if the dataobject is instance of JavaDataObejct and that it represents a file
        // that is on the IDE classpath (belongs to one of open projects)
        if ((dobj instanceof JavaDataObject) && ((JMManager) JavaMetamodel.getManager()).mergedCPContains(dobj.getPrimaryFile())) {
            return true;
        }
        return false;
    }
}
