/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefObject;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.EncapsulateFieldsRefactoring;
import org.netbeans.modules.refactoring.api.EncapsulateFieldsRefactoring.EncapsulateFieldInfo;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Element;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 *
 * @author  Tomas Hurka
 * @author  Pavel Flaska
 */
public class EncapsulateFieldUI implements RefactoringUI {

    private EncapsulateFieldPanel panel;
    private transient String setter;
    private transient String getter;
    private transient EncapsulateFieldsRefactoring refactoring;
    private boolean componentsReady;
    
    /** Creates new form RenamePanelName */
    public EncapsulateFieldUI(Element[] selectedObjects) {
        refactoring = new EncapsulateFieldsRefactoring(selectedObjects);
    }
    
    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (panel == null) {
            parent.setPreviewEnabled(true);
            panel = new EncapsulateFieldPanel(refactoring.getFields(), parent);
        }
        return panel;
    }

    private Problem setParameters(boolean checkOnly) {
        List result = new ArrayList();
        int[] modifiers = panel.getModifiers();
        DefaultTableModel model = panel.getTableModel();
        List rows = model.getDataVector();
        Field[] fields = panel.getAllFields();
        int i = 0;
        for (Iterator rowIt = rows.iterator(); rowIt.hasNext(); i++) {
            List item = (List) rowIt.next();
            if (((Boolean) item.get(1)) == Boolean.TRUE || ((Boolean) item.get(3)) == Boolean.TRUE) {
                String getterName = (String) item.get(2);
                String setterName = (String) item.get(4);
                result.add(new EncapsulateFieldInfo(fields[i], "".equals(getterName)?null:getterName, "".equals(setterName)?null:setterName)); // NOI18N
            }
        }
        refactoring.setRefactorFields((EncapsulateFieldInfo[]) result.toArray(new EncapsulateFieldInfo[result.size()]));
        refactoring.setMethodModifier(modifiers[0]);
        refactoring.setFieldModifier(modifiers[1]);
        refactoring.setAlwaysUseAccessors(panel.isCheckAccess());
        if (checkOnly) {
            return refactoring.fastCheckParameters();
        } else {
            return refactoring.checkParameters();
        }
    }

    public AbstractRefactoring getRefactoring() {
        return refactoring;
    }

    public String getDescription() {
        ClassDefinition decl=((Field) refactoring.getFields()[0]).getDeclaringClass();
        String name="<anonymous>"; // NOI18N
        
        if (decl instanceof JavaClass) 
            name=((JavaClass)decl).getName();
        return new MessageFormat(NbBundle.getMessage(EncapsulateFieldUI.class, "DSC_EncapsulateFields")).format (
                    new Object[] {name}
                );
    }

    public String getName() {
        return NbBundle.getMessage(EncapsulateFieldUI.class, "LBL_EncapsulateFields");
    }
    
    public Problem checkParameters() {
        return setParameters(true);
    }
    
    public Problem setParameters() {
        return setParameters(false);
    }

    public boolean hasParameters() {
        return true;
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx(EncapsulateFieldUI.class);
    }
}
