/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import javax.swing.JEditorPane;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Element;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/**
 *
 * @author thurka
 */
public class EncapsulateFieldAction extends AbstractRefactoringAction {
    /** Creates a new instance of RenameAction */
    public EncapsulateFieldAction() {
        super(NbBundle.getMessage(EncapsulateFieldAction.class, "LBL_EncapsulateFieldsAction"), null);
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    protected RefactoringUI createRefactoringUI(Node[] nodes, Element selectedElement) {
        Element[] selectedObjects;
        if (selectedElement !=null) {
            Feature declFeature = JavaModelUtil.getDeclaringFeature(selectedElement);
            if (declFeature instanceof Field) {
                selectedElement = declFeature;
            } else if (selectedElement instanceof ElementReference) {
                selectedElement = ((ElementReference) selectedElement).getElement();
            }
            selectedObjects=new Element[]{selectedElement};
        }
        else {
            selectedObjects = new Element[nodes.length];
            for (int i = 0; i < nodes.length; i++) {
                Node selNode = nodes[i];
                selectedObjects[i] = (Element) selNode.getLookup().lookup(Element.class);
            }
        }
        return new EncapsulateFieldUI(selectedObjects);
    }
    
    protected boolean enabled(Node[] activatedNodes) {
        if (activatedNodes.length < 1)
            return false;
        DataObject dobj = (DataObject) activatedNodes[0].getCookie(DataObject.class);
        if (dobj!=null)
            if (!((JMManager) JMManager.getManager()).mergedCPContains(dobj.getPrimaryFile()))
                return false;

        TopComponent activetc = TopComponent.getRegistry().getActivated();
        if (activetc instanceof CloneableEditorSupport.Pane) {
            JEditorPane pane=((CloneableEditorSupport.Pane)activetc).getEditorPane();
            if (pane!=null) {
                return dobj instanceof JavaDataObject;
            }
        }
        
        Element el = (Element) activatedNodes[0].getLookup().lookup(Element.class);
        if (el == null) {
            return false;
        }
        if (el instanceof JavaClass) {
            return activatedNodes.length == 1;
        }
        for (int i = 0; i < activatedNodes.length; i++) {
            if (activatedNodes[i].getLookup().lookup(Field.class) == null)
                return false;
        }
        return true;
    }
}
