/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.datatransfer.ExClipboard.Convertor;
import org.openide.util.datatransfer.PasteType;

/**
 * @author Jan Becicka
 */

public class ClipboardConvertor implements Convertor {

    public Transferable convert(Transferable t) {
        Node[] nodes = NodeTransfer.nodes(t, 4);
        
        if (nodes!=null && nodes.length>0) {
            HashSet dataObjects = new HashSet();
            if (getDOs(nodes, dataObjects)) {
                return NodeTransfer.createPaste(new RefactoringPaste(t, nodes, dataObjects));
            }
        }
        return t;
    }
    
    private class RefactoringPasteType extends PasteType {
        
        Node target;
        Transferable orig;
        Set dataObjects;
        RefactoringPasteType(Transferable orig, Node target, Set dataObjects) {
            this.target = target;
            this.orig = orig;
            this.dataObjects = dataObjects;
        }
        public Transferable paste() throws IOException {
            Node[] nodes = NodeTransfer.nodes(orig, NodeTransfer.CLIPBOARD_CUT);

            DataObject dob = (DataObject) target.getCookie(DataObject.class);
            final PasteType[] types = target.getPasteTypes(orig);
            if (types==null || types.length==0) {
                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, new Exception("No paste type available")); // NOI18N
                return null;
            }
            
            if (!isOnClassPath(dob)) {
                types[0].paste();
            } else {
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        MoveClassAction move = ((MoveClassAction) MoveClassAction.findObject(MoveClassAction.class));
                        move.performAction(dataObjects, ((DataFolder) target.getCookie(DataFolder.class)).getPrimaryFile(), types[0]);
                    };
                });
            }
            return null;
        }
    }

    private class RefactoringPaste implements NodeTransfer.Paste {
        
        private Transferable orig;
        private Node nodes;
        private Set dataObjects;
        RefactoringPaste(Transferable t) {
            orig = t;
        }
        RefactoringPaste(Transferable t, Node noodes[], Set dataObjects) {
            orig = t;
            this.nodes = nodes;
            this.dataObjects = dataObjects;
        }
        
        public PasteType[] types (Node target) {
            if (target instanceof DataFolder.FolderNode)
                return new PasteType[] {new RefactoringPasteType(orig, target, dataObjects)};
            return target.getPasteTypes(orig);  
        }
    }

    private boolean getDOs(Node[] nodes, Set result) {
        Set folders = new HashSet();
        boolean jdoFound = false;
        for (int i=0; i<nodes.length; i++) {
            DataObject dob = (DataObject) nodes[i].getCookie(DataObject.class);
            if (!isOnClassPath(dob)) {
                return false;
            }
            if (dob instanceof DataFolder) {
                folders.add(dob);
            } else if (dob instanceof JavaDataObject) {
                jdoFound = true;
            }
            
            result.add(dob);
        }
        if (jdoFound)
            return true;
        for (Iterator i = folders.iterator(); i.hasNext();) {
            DataFolder fold = (DataFolder) i.next();
            for (Enumeration e = (fold).children(true); e.hasMoreElements();) {
                if (e.nextElement() instanceof JavaDataObject) {
                    return true;
                }
            }
        }
        return false;
    }
    
    private static final boolean isOnClassPath(DataObject dob) {
        if (dob == null )
            return false;

        if (!((JMManager) JavaMetamodel.getManager()).getMergedClassPath().contains(dob.getPrimaryFile()))
                return false;
        return true;
    }
}
