/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import javax.jmi.reflect.RefObject;
import javax.swing.JEditorPane;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;

import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Lookup;

import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.jmi.javamodel.*;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.windows.TopComponent;


/**
 * Activates change method signature refactoring. It is possible to do it
 * on methods and constructors.
 *
 * @author  Pavel Flaska
 */
public class ChangeParametersAction extends AbstractRefactoringAction {
    
    public ChangeParametersAction() {
        super(NbBundle.getMessage(ChangeParametersAction.class,
            "LBL_ChangeMethodSignatureAction"), null); // NOI18N
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    protected RefactoringUI createRefactoringUI(Node[] nodes, org.netbeans.jmi.javamodel.Element selectedElement) {
        RefObject representedObject = selectedElement;
        
        if (representedObject != null) {
            if (representedObject instanceof ElementReference) {
                representedObject = ((ElementReference)representedObject).getElement();
            }            
        }
        else {
            Lookup lkp = nodes[0].getLookup();
            representedObject = (Element) lkp.lookup(Element.class);
            if (representedObject == null) {
                DataObject dob = (DataObject) lkp.lookup(DataObject.class);
                if (dob != null) {
                    Resource res = JavaModel.getResource(dob.getPrimaryFile());
                    representedObject = res;
                }
            }
        } 
        return new ChangeParametersUI(representedObject);
    }
    
    public HelpCtx getHelpCtx() {
        // todo (#pf): provide context help
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected boolean enabled(Node[] activatedNodes) {
        if (activatedNodes.length != 1)
            return false;
        DataObject dobj = (DataObject) activatedNodes[0].getCookie(DataObject.class);
        if (dobj!=null)
            if (!((JMManager) JMManager.getManager()).mergedCPContains(dobj.getPrimaryFile()))
                return false;
        
        TopComponent activetc = TopComponent.getRegistry().getActivated();
        if (activetc instanceof CloneableEditorSupport.Pane) {
            JEditorPane pane=((CloneableEditorSupport.Pane)activetc).getEditorPane();
            if (pane!=null) {
                return dobj instanceof JavaDataObject;
            }
        }
        
        Element el = (Element) activatedNodes[0].getLookup().lookup(Element.class);
        if (el == null) {
            return false;
        }
        if (el instanceof CallableFeature) {
            return activatedNodes.length == 1;
        }
        
        return false;
    }

}
