/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.refactoring.api.AnonymousToInnerRefactoring;
import org.netbeans.modules.refactoring.api.AnonymousToInnerRefactoring.ParameterInfo;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author Daniel Prusa
 */
public class AnonymousToInnerRefactoringUI implements RefactoringUI {
    private final AnonymousToInnerRefactoring refactoring;
    private AnonymousToInnerPanel panel;

    public AnonymousToInnerRefactoringUI(ClassDefinition classDef) {
        refactoring = new AnonymousToInnerRefactoring(classDef);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(org.netbeans.modules.refactoring.spi.ui.ParametersPanel parent) {
        if (panel == null) {
            panel = new AnonymousToInnerPanel(refactoring, parent);
        }
        return panel;
    }

    public org.netbeans.modules.refactoring.api.Problem setParameters() {
        refactoring.setName(panel.getInnerName());
        refactoring.setModifiers(panel.getModifiers());
        
        List data = (List) panel.getTableModel().getDataVector();
        ParameterInfo[] paramList = refactoring.getParamTable();
        int counter = 0;
        for (Iterator rowIt = data.iterator(); rowIt.hasNext(); ++counter) {
            List row = (List) rowIt.next();
            String name = (String) row.get(0);
            Variable var = (Variable) row.get(2);
            
            paramList[counter] = new ParameterInfo(var);
            paramList[counter].setName(name);
        }
        return refactoring.checkParameters();
    }
    
    public org.netbeans.modules.refactoring.api.Problem checkParameters() {
        refactoring.setName(panel.getInnerName());
        refactoring.setModifiers(panel.getModifiers());
        return refactoring.fastCheckParameters();
    }

    public org.netbeans.modules.refactoring.api.AbstractRefactoring getRefactoring() {
        return refactoring;
    }

    public String getDescription() {
        return ""; // NOI18N [TODO]
        /*
        return new MessageFormat(NbBundle.getMessage(AnonymousToInnerAction.class, "DSC_AnonymousToInner")).format (
                    new Object[] {dispOldName, newName}
                );
         */
    }

    public String getName() {
        return NbBundle.getMessage(AnonymousToInnerAction.class, "LBL_AnonymousToInner");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AnonymousToInnerRefactoringUI.class.getName());
    }
}
