/*
 * AnonymousToInnerPanel.java
 *
 * Created on April 18, 2005, 1:58 PM
 */

package org.netbeans.modules.refactoring.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.refactoring.api.AnonymousToInnerRefactoring;
import org.netbeans.modules.refactoring.api.AnonymousToInnerRefactoring.ParameterInfo;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.openide.actions.EditAction;
import org.openide.util.NbBundle;

/**
 *
 * @author  Daniel Prusa
 */
public class AnonymousToInnerPanel extends CustomRefactoringPanel {

    private static final String[] modifierNames = {
        "public", // NOI18N
        "protected", // NOI18N
        "<default>", // NOI18N
        "private" // NOI18N
    };
    // modifier items in combo - indexes
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final String[] columnNames = {
        getString("LBL_AnonymousToInnerColName"), // NOI18N
        getString("LBL_AnonymousToInnerColType"), // NOI18N
        "Variable",                            // NOI18N
    };
    private static final String ACTION_INLINE_EDITOR = "invokeInlineEditor";  //NOI18N
    private static Action editAction = null;
    private ParametersPanel parentPanel;
    private ParamTableModel model;
    private AnonymousToInnerRefactoring refactoring;
    private boolean initialized;
    
    /** Creates new form AnonymousToInnerPanel */
    public AnonymousToInnerPanel(AnonymousToInnerRefactoring ref, ParametersPanel parent) {
        parentPanel = parent;
        refactoring = ref;
        model = new ParamTableModel(columnNames, 0);  
        initComponents();
    }

    
    public void initialize() {
        if (!initialized) {
            nameField.setText("NewClass");//NOI18N
            staticCheckBox.setSelected((refactoring.getModifiers() & Modifier.STATIC) != 0);
            setAccessModifier();
            initTableData();
            nameField.requestFocus();
            nameField.getDocument().addDocumentListener(new DocumentListener() {
                public void changedUpdate(DocumentEvent event) {
                    parentPanel.stateChanged(null);
                }
                public void insertUpdate(DocumentEvent event) {
                    parentPanel.stateChanged(null);
                }
                public void removeUpdate(DocumentEvent event) {
                    parentPanel.stateChanged(null);
                }
            });
            nameField.setSelectionStart(0);
            nameField.setSelectionEnd(nameField.getText().length());
            initialized=true;
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        parameters = new javax.swing.JLabel();
        staticCheckBox = new javax.swing.JCheckBox();
        eastPanel = new javax.swing.JPanel();
        buttonsPanel = new javax.swing.JPanel();
        moveUpButton = new javax.swing.JButton();
        moveDownButton = new javax.swing.JButton();
        fillPanel = new javax.swing.JPanel();
        westPanel = new javax.swing.JScrollPane();
        paramTable = new javax.swing.JTable();
        modifiersLabel = new javax.swing.JLabel();
        modifiersCombo = new javax.swing.JComboBox();
        name = new javax.swing.JLabel();
        nameField = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        setName(java.util.ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_AnonymousToInner"));
        parameters.setLabelFor(paramTable);
        org.openide.awt.Mnemonics.setLocalizedText(parameters, org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "LBL_AnonymousToInnerParameters"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        add(parameters, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(staticCheckBox, org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "LBL_AnonymousToInnerStatic"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 0);
        add(staticCheckBox, gridBagConstraints);
        staticCheckBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "ACSD_DeclareStatic"));
        staticCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "ACSD_DeclareStaticDescription"));

        eastPanel.setLayout(new java.awt.GridBagLayout());

        buttonsPanel.setLayout(new java.awt.GridBagLayout());

        buttonsPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 11, 1, 1));
        moveUpButton.setMnemonic(getString("LBL_AnonymousToInnerMoveUp_MNEM").charAt(0));
        org.openide.awt.Mnemonics.setLocalizedText(moveUpButton, java.util.ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_AnonymousToInnerMoveUp"));
        moveUpButton.setEnabled(false);
        moveUpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveUpButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        buttonsPanel.add(moveUpButton, gridBagConstraints);

        moveDownButton.setMnemonic(getString("LBL_AnonymousToInnerMoveDown_MNEM").charAt(0));
        org.openide.awt.Mnemonics.setLocalizedText(moveDownButton, java.util.ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_AnonymousToInnerMoveDown"));
        moveDownButton.setEnabled(false);
        moveDownButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveDownButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        buttonsPanel.add(moveDownButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        eastPanel.add(buttonsPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        eastPanel.add(fillPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(eastPanel, gridBagConstraints);

        westPanel.setPreferredSize(new java.awt.Dimension(453, 100));
        paramTable.setModel(model);
        initRenderer();
        paramTable.getSelectionModel().addListSelectionListener(getListener1());
        paramTable.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        model.addTableModelListener(getListener2());
        paramTable.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_SPACE, 0), ACTION_INLINE_EDITOR); //NOI18N
        paramTable.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0), ACTION_INLINE_EDITOR); //NOI18N
        paramTable.getActionMap().put(ACTION_INLINE_EDITOR, getEditAction()); //NOI18N
        paramTable.setSurrendersFocusOnKeystroke(true);
        paramTable.setCellSelectionEnabled(false);
        paramTable.setRowSelectionAllowed(true);
        paramTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE); //NOI18N
        paramTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE); //NOI18N

        westPanel.setViewportView(paramTable);
        paramTable.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "ACSD_paramTable"));
        paramTable.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "ACSD_paramTable"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(westPanel, gridBagConstraints);

        modifiersLabel.setDisplayedMnemonic(getString("LBL_AnonymousToInnerMods_MNEM").charAt(0));
        modifiersLabel.setLabelFor(modifiersCombo);
        org.openide.awt.Mnemonics.setLocalizedText(modifiersLabel, java.util.ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_AnonymousToInnerMods"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(modifiersLabel, gridBagConstraints);

        modifiersCombo.setModel(new DefaultComboBoxModel(modifierNames));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 0);
        add(modifiersCombo, gridBagConstraints);
        modifiersCombo.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "ACSD_methodAcc"));
        modifiersCombo.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "ACSD_methodAcc"));

        name.setLabelFor(nameField);
        org.openide.awt.Mnemonics.setLocalizedText(name, org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "LBL_AnonymousToInnerName"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(name, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 0);
        add(nameField, gridBagConstraints);
        nameField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "ACSD_InnerClassName"));
        nameField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AnonymousToInnerPanel.class, "ACSD_InnerClassNameDescription"));

    }
    // </editor-fold>//GEN-END:initComponents

    private void moveDownButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveDownButtonActionPerformed
        doMove(1);
    }//GEN-LAST:event_moveDownButtonActionPerformed

    private void moveUpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveUpButtonActionPerformed
        doMove(-1);
    }//GEN-LAST:event_moveUpButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonsPanel;
    private javax.swing.JPanel eastPanel;
    private javax.swing.JPanel fillPanel;
    private javax.swing.JComboBox modifiersCombo;
    private javax.swing.JLabel modifiersLabel;
    private javax.swing.JButton moveDownButton;
    private javax.swing.JButton moveUpButton;
    private javax.swing.JLabel name;
    private javax.swing.JTextField nameField;
    private javax.swing.JTable paramTable;
    private javax.swing.JLabel parameters;
    private javax.swing.JCheckBox staticCheckBox;
    private javax.swing.JScrollPane westPanel;
    // End of variables declaration//GEN-END:variables
 

    // --- GETTERS FOR REFACTORING PARAMETERS ----------------------------------
    
    /** Getter used by the refactoring UI to get value
     * of target type.
     * @return Target type.
     */
    public String getInnerName() {
        return nameField.getText();
    }
    
    public void requestFocus() {
        nameField.requestFocus();
    }

    public int getModifiers() {
        int mod = 0;
        switch (modifiersCombo.getSelectedIndex()) {
            case MOD_PRIVATE_INDEX: 
                mod = Modifier.PRIVATE;
            break;
            case MOD_PUBLIC_INDEX:
                mod = Modifier.PUBLIC;
            break;
            case MOD_PROTECTED_INDEX:
                mod = Modifier.PROTECTED;
            break;
        }
        return mod | (staticCheckBox.isSelected() ? Modifier.STATIC : 0);
    }
    
    protected DefaultTableModel getTableModel() {
        return model;
    }
    
    private ListSelectionListener getListener1() {
        return new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if (!initialized || e.getValueIsAdjusting())
                    return;
                
                ListSelectionModel lsm = (ListSelectionModel) e.getSource();

                if (!lsm.isSelectionEmpty()) {
                    // Find out which indexes are selected.
                    int minIndex = lsm.getMinSelectionIndex();
                    int maxIndex = lsm.getMaxSelectionIndex();
                    setButtons(minIndex, maxIndex);                    
                } else {
                    moveDownButton.setEnabled(false);
                    moveUpButton.setEnabled(false);
                }
            }
        };
    }

    private TableModelListener getListener2() {
        return new TableModelListener() {
            public void tableChanged(TableModelEvent e) {
                if (!initialized)
                    return;
                // update buttons availability
                int[] selectedRows = paramTable.getSelectedRows();
                if (selectedRows.length != 0) {
                    int min = selectedRows[0];
                    int max = selectedRows[selectedRows.length - 1];
                    setButtons(min, max);
                }
                
                // update preview
                //previewChange.setText(genDeclarationString());
                
                parentPanel.stateChanged(null);
            }
        };
    }

    private boolean acceptEditedValue() {
        TableCellEditor tce = paramTable.getCellEditor();
        if (tce != null)
            return paramTable.getCellEditor().stopCellEditing();
        return false;
    }

    private void doMove(int step) {
        acceptEditedValue(); 
        
        ListSelectionModel selectionModel = paramTable.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        
        selectionModel.clearSelection();
        model.moveRow(min, max, min + step);
        selectionModel.addSelectionInterval(min + step, max + step);
    }
    
    private void setButtons(int min, int max) {
        int r = model.getRowCount() - 1;
        moveUpButton.setEnabled(min > 0 ? true : false);
        moveDownButton.setEnabled(max < r ? true : false);
    }

    private static String getString(String key) {
        return NbBundle.getMessage(AnonymousToInnerPanel.class, key);
    }

    private void initRenderer() {
        TableColumnModel tcm = paramTable.getColumnModel();
        Enumeration columns = paramTable.getColumnModel().getColumns();

        paramTable.removeColumn(tcm.getColumn(2));
        while (columns.hasMoreElements()) {
            TableColumn tc = (TableColumn) columns.nextElement();
            
            tc.setCellRenderer(new ParamRenderer());
        }
    }

    private void setAccessModifier() {
        int mod = refactoring.getModifiers();
        
        if (Modifier.isPrivate(mod))
            modifiersCombo.setSelectedIndex(MOD_PRIVATE_INDEX);
        else if (Modifier.isProtected(mod))
            modifiersCombo.setSelectedIndex(MOD_PROTECTED_INDEX);
        else if (Modifier.isPublic(mod))
            modifiersCombo.setSelectedIndex(MOD_PUBLIC_INDEX);
        else
            modifiersCombo.setSelectedIndex(MOD_DEFAULT_INDEX);
    }

    private void initTableData() {
        int i;
        ParameterInfo[] pars=refactoring.getParamTable();
        
        for (i=0;i<pars.length;i++) {
            ParameterInfo par=pars[i];
            Variable var=par.getVariable();
            
            Object[] row=new Object[]{par.getName(),var.getType().getName(),var};
            
            model.addRow(row);
        }
    }
    
    private static Action getEditAction() {
        if (editAction == null) {
            editAction = new EditAction();
        }
        return editAction;
    }
    
    class ParamRenderer extends DefaultTableCellRenderer implements TableCellRenderer {
        Color origBackground;
        
        public ParamRenderer() {
            setOpaque(true);
            origBackground = getBackground();
        }
        
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus,
                                                       int row, int column)
        {
            super.getTableCellRendererComponent(table,  value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                setBackground(UIManager.getColor("Panel.background")); // NOI18N
            }
            return this;
        }
    }

    static class ParamTableModel extends DefaultTableModel {
        
        public ParamTableModel(Object[] data, int rowCount) {
            super(data, rowCount);
        }

        public boolean isCellEditable(int row, int column) {
            if (column > 0) {
                // check box indicating usage of parameter is not editable
                return false;
            }
            return true;
        }
        
        public Class getColumnClass(int c) {
            return getValueAt(0, c).getClass();
        }
    }    
}
