/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.refactoring.classpath.Util;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.jmi.javamodel.*;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/**
 *
 * @author Daniel Prusa
 */
public class AnonymousToInnerAction extends AbstractRefactoringAction {

    public AnonymousToInnerAction() {
        super(NbBundle.getMessage(AnonymousToInnerAction.class, "LBL_AnonymousToInnerAction"), null);
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    protected RefactoringUI createRefactoringUI(Node[] nodes, org.netbeans.jmi.javamodel.Element selectedElement) {
        Element elem = selectedElement;
        while (elem != null && !(elem instanceof NewClassExpression)) {
            elem = (Element) elem.refImmediateComposite();
        }
        ClassDefinition cd = elem != null ? ((NewClassExpression) elem).getClassDefinition() : null;
        return new AnonymousToInnerRefactoringUI(cd);
    }
    
    protected boolean enabled(Node[] activatedNodes) {
        if (activatedNodes.length != 1) 
            return false;
        
        DataObject dobj = (DataObject) activatedNodes[0].getCookie(DataObject.class);
        if ((dobj instanceof JavaDataObject) && Util.isUnderSourceRootOfOpenProjects(dobj.getPrimaryFile())) {
            return true;
        } else {
            return false;
        }
    }
}
