/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.plugins;

import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.refactoring.CommentFinder;
import org.netbeans.modules.refactoring.WhereUsedElement;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.openide.util.NbBundle;


/**
 *
 * @author  Martin Matula, Jan Becicka
 */
public class WhereUsedQueryPlugin extends JavaRefactoringPlugin implements ProgressListener {
    private RefObject jmiObject;
    private boolean baseClass;
    private boolean overriders;
    private boolean subclasses;
    private boolean directOnly;
    private boolean findUsages=true;
    private WhereUsedQuery refactoring;

    
    /** Creates a new instance of WhereUsedQuery */
    public WhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
        this.jmiObject = (RefObject) refactoring.getRefactoredObject();
    }
    
    public Problem preCheck() {
        Problem p = isElementAvail((Element) jmiObject);
        if (p != null)
            return p;

        if (jmiObject instanceof UnresolvedClass) {
            return new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, "DSC_ElNotAvail")); // NOI18N
        }
        
        if (!((jmiObject instanceof Feature) || (jmiObject instanceof Variable) || (jmiObject instanceof JavaPackage) || (jmiObject instanceof TypeParameter)) ) {
            return new Problem(true, NbBundle.getMessage(WhereUsedQuery.class, "ERR_WhereUsedWrongType"));
        }

        return p;
    }
    
    public Problem prepare(RefactoringElementsBag elements) {
        boolean searchComments;
        CommentFinder docFinder=null;

        JavaMetamodel.getManager().getProgressSupport().addProgressListener(this);
        
        //fireProgressListenerStart(refactoring.PREPARE, 8);
        try {
            long startT = 0, finishT;
            if (JMManager.PERF_DEBUG) {
                startT = System.currentTimeMillis();
            }
            if (searchComments=refactoring.isFindUsages() && refactoring.isSearchInComments()) {
                Resource newRsc=convertResource();
                
                docFinder=new CommentFinder((Element)jmiObject);
                if (newRsc!=null) 
                    elements.addAll(refactoring, docFinder.searchCommentsInResource(newRsc));
            }
            if (jmiObject instanceof Method)
                referencesIterator = ((Method) jmiObject).findDependencies(findUsages, false, overriders).iterator();
            else {
                if (jmiObject instanceof JavaClass && (subclasses || directOnly)) {
                    referencesIterator = ((JavaClass) jmiObject).findSubTypes(!directOnly).iterator();
                } else {
                    referencesIterator = ((NamedElement) jmiObject).getReferences().iterator();
                }
            }
            while (referencesIterator.hasNext()) {
                Element element = (Element) referencesIterator.next();
                Resource rsc=element.getResource();

                if ((rsc.getStatus() & ResourceImpl.IS_FROM_CLASSFILE) == 0) {
                    if (cancelRequest) {
                        //cancel
                        return null;
                    }
                    if (searchComments) {
                        elements.addAll(refactoring, docFinder.searchCommentsInResource(rsc));
                    }
                    elements.add(refactoring, new WhereUsedElement(jmiObject, element));
                }
            }
            if (JMManager.PERF_DEBUG) {
                finishT = System.currentTimeMillis();
                long deltaT = finishT - startT;
                System.out.print("PERF: Collecting usages of '"); //NOI18N
                if (jmiObject instanceof NamedElement) {
                     System.out.print(((NamedElement) jmiObject).getName());
                }
                else {
                    System.out.print("unknown"); //NOI18N
                }
                System.out.println("' takes " + deltaT + " ms."); //NOI18N
            }
            return null;
        } finally {
            referencesIterator = null;
            JavaMetamodel.getManager().getProgressSupport().removeProgressListener(this);
            //fireProgressListenerStop();
        }
    }
    
    public Problem fastCheckParameters() {
        if (jmiObject instanceof Method) {
            return checkParametersForMethod(refactoring.isSearchFromBaseClass(), refactoring.isFindOverridingMethods(), refactoring.isFindUsages());
        } else if (jmiObject instanceof JavaClass) {
            return checkParametersForClass(refactoring.isFindSubclasses(), refactoring.isFindDirectSubclassesOnly());
        }
        return null;
    }
        
    public Problem checkParameters() {
        if (jmiObject instanceof Method) {
            return setParametersForMethod(refactoring.isSearchFromBaseClass(), refactoring.isFindOverridingMethods(), refactoring.isFindUsages());
        } else if (jmiObject instanceof JavaClass) {
            return setParametersForClass(refactoring.isFindSubclasses(), refactoring.isFindDirectSubclassesOnly());
        }
        return null;
    }

    private Problem checkParametersForMethod(boolean baseClass, boolean overriders, boolean usages) {
        if (!(usages || overriders)) {
            return new Problem(true, NbBundle.getMessage(WhereUsedQuery.class, "MSG_NothingToFind"));
        } else 
            return null;
    }
    
    private Problem setParametersForMethod(boolean baseClass, boolean overriders, boolean usages) {
        this.baseClass = baseClass;
        this.overriders = overriders;
        this.findUsages = usages;
        
        if (baseClass) {
            Collection  c = JavaModelUtil.getOverriddenMethods((Method) jmiObject);
            if (!c.isEmpty()) {
                jmiObject = (Method) c.iterator().next();
            }
        }
        return null;
    }
    
    private Resource convertResource() {
        Resource rsc=((Element)jmiObject).getResource();

        if (rsc!=null) {
            Iterator classIt=rsc.getClassifiers().iterator();

            if (classIt.hasNext()) {
                JavaClass jcls=(JavaClass)classIt.next();
                JavaModelPackage pck=(JavaModelPackage)jcls.refImmediatePackage();
                Type newJcls=pck.getType().resolve(jcls.getName());

                if (newJcls!=null) {
                    Resource newRsc=newJcls.getResource();
                    CodebaseClass cbClass=((JavaModelPackage)newRsc.refImmediatePackage()).getCodebase();
                    Codebase cb=(Codebase)cbClass.refAllOfClass().iterator().next();
                    
                    if (newRsc!=null && newRsc.getName().endsWith(".java") && !cb.isLibrary()) // NOI18N
                        return newRsc;
                }
            }
        }
        return null;
    }
    
    private Problem checkParametersForClass(boolean subclasses, boolean transitively) {
        return null;
    }
    
    private Problem setParametersForClass(boolean subclasses, boolean directOnly) {
        this.subclasses = subclasses;
        this.directOnly = directOnly;
        return null;
    }
    
    public void start(ProgressEvent event) {
        fireProgressListenerStart(event.getOperationType(), event.getCount());
    }
    
    public void step(ProgressEvent event) {
        fireProgressListenerStep();
    }
    
    public void stop(ProgressEvent event) {
        fireProgressListenerStop();
    }
}
