/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.plugins;

import org.netbeans.modules.refactoring.api.*;
import org.netbeans.modules.refactoring.spi.*;

/**
 *
 * @author Jan Becicka
 */
public class JavaRefactoringsFactory implements RefactoringPluginFactory {
   
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        if (refactoring instanceof RenameRefactoring) {
            return new RenameRefactoringPlugin((RenameRefactoring) refactoring);
        }
        if (refactoring instanceof EncapsulateFieldsRefactoring) {
            return new EncapsulateFieldsPlugin((EncapsulateFieldsRefactoring) refactoring);
        }
        if (refactoring instanceof EncapsulateFieldRefactoring) {
            return new EncapsulateFieldRefactoringPlugin((EncapsulateFieldRefactoring) refactoring);
        }
        if (refactoring instanceof ExtractMethodRefactoring) {
            return new ExtractMethodRefactoringPlugin((ExtractMethodRefactoring) refactoring);
        }
        if (refactoring instanceof WhereUsedQuery) {
            return new WhereUsedQueryPlugin((WhereUsedQuery) refactoring);
        }
        if (refactoring instanceof MoveClassRefactoring) {
            return new MoveClassRefactoringPlugin((MoveClassRefactoring) refactoring);
        }
        if (refactoring instanceof ChangeParametersRefactoring) {
            return new ChangeParametersPlugin((ChangeParametersRefactoring) refactoring);
        }
        if (refactoring instanceof SafeDeleteRefactoring) {
            return new SafeDeleteRefactoringPlugin((SafeDeleteRefactoring) refactoring);
        }
        if (refactoring instanceof ExtractInterfaceRefactoring) {
            return new ExtractInterfaceRefactoringPlugin((ExtractInterfaceRefactoring) refactoring);
        }
        if (refactoring instanceof ExtractSuperClassRefactoring) {
            return new ExtractSuperClassRefactoringPlugin((ExtractSuperClassRefactoring) refactoring);
        }
        if (refactoring instanceof PushDownRefactoring) {
            return new PushDownRefactoringPlugin((PushDownRefactoring) refactoring);
        }
        if (refactoring instanceof PullUpRefactoring) {
            return new PullUpRefactoringPlugin((PullUpRefactoring) refactoring);
        }
        if (refactoring instanceof AnonymousToInnerRefactoring) {
            return new AnonymousToInnerRefactoringPlugin((AnonymousToInnerRefactoring) refactoring);
        }
        if (refactoring instanceof InnerToOuterRefactoring) {
            return new InnerToOuterRefactoringPlugin((InnerToOuterRefactoring) refactoring);
        }
        if (refactoring instanceof UseSuperTypeRefactoring) {
            return new UseSuperTypeRefactoringPlugin((UseSuperTypeRefactoring) refactoring);
        }
        return null;
    }
    
}
