/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.api;

import java.lang.reflect.Modifier;
import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.refactoring.classpath.Util;


/**
 * @author Daniel Prusa
 */
public final class AnonymousToInnerRefactoring extends AbstractRefactoring {    
    
    private ClassDefinition classDefinition;
    private String name;
    private int modifiers;
    private ParameterInfo[] paramTable;
    
    /**
     * Creates a new instance of AnonymousToInner
     * @param classDef Anonymous inner class that should be converted into nested class
     */
    public AnonymousToInnerRefactoring(ClassDefinition classDef) {
        this.classDefinition = classDef;
        this.modifiers = Modifier.PRIVATE;
        
        if (classDefinition != null) {
            JavaClass superType = null;
            JavaClass superClass = classDefinition.getSuperClass();
            if (superClass != null && !"java.lang.Object".equals(superClass.getName())) { // NOI18N
                superType = superClass;
            } else {
                List list = classDefinition.getInterfaces();
                if (list.size() > 0) {
                    superType = (JavaClass) list.get(0);
                }
            }
            name = superType != null ? "My" + superType.getSimpleName() : null; // NOI18N
        }
    }
    
    /**
     * Getter for property name
     * @return Value of property variableName
     */
    public String getName() {
        return name;
    }
    
    /**
     * Setter for propety name
     * @param name New value of property name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for property modifiers
     * @return modifiers
     */
    public int getModifiers() {
        return modifiers;
    }
    
    /**
     * Setter for property modifiers
     * @param modifiers New value of property modifiers
     */
    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }
    
    /**
     * Getter for property paramTable
     * @return paramTable
     */
    public ParameterInfo[] getParamTable() {
        return paramTable;
    }

    /**
     * Setter for property paramTable
     * @param paramTable New value of property paramTable
     */
    public void setParamTable(ParameterInfo[] parTable) {
        paramTable = parTable;
    }
    
    /**
     * Getter for property classDefinition
     * @return expression
     */
    public ClassDefinition getClassDefinition() {
        return classDefinition;
    }
    
    protected void setClassPath() {
        Util.setClassPath(classDefinition);
    }
    
    /**
     * Represents one item for setParameters(List params) list parameter.
     * Item contains information about method parameters.
     */
    public static final class ParameterInfo {
        String name;
        Variable variable;

        /**
         * Creates a new instanceof of ParameterInfo. You have to provide not
         * null values, otherwise it throws an
         * IllegalArgumentException.
         *
         * @param  type       parameter type
         */
        public ParameterInfo(Variable var) {
            if (var == null)
                throw new IllegalArgumentException();
            name = var.getName();
            variable = var;
        }
                
        /**
         * Returns value of the name of parameter. 
         *
         * @return  new name for parameter
         */
        public String getName() { return name; }
        
        public void setName(String n) {
            name = n;
        }

        /**
         * Returns value of the type of parameter.
         *
         * @return new type for parameter
         */
        public Variable getVariable() { return variable; }

    }    
}
