/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;

/** Class containing various utility methods.
 *
 * @author Martin Matula
 */
public final class Utilities {
    private Utilities() {
    }
    
    /** Helper method for determining whether there is a source available
     * for a given type.
     * @return true if the source is available, false otherwise.
     */
    public static boolean isFromSource(JavaClass type) {
        Resource resource = type.getResource();
        return resource != null && (resource.getStatus() & ResourceImpl.IS_FROM_CLASSFILE) == 0;
    }
    
    /** Method for extracting types of parameters of a given callable feature
     * (i.e. method or constructor).
     * @returns List of parameter types.
     */
    public static List getFeatureParamTypes(CallableFeature feature) {
        ArrayList result = new ArrayList();
        for (Iterator it = feature.getParameters().iterator(); it.hasNext();) {
            Type type = ((Parameter) it.next()).getType();
            while (type instanceof ParameterizedType) {
                type = ((ParameterizedType) type).getDefinition();
            }
            result.add(type);
        }
        return result;
    }
    
    /** Duplicates list of metadata elements.
     * @param list List of metadata elements to be duplicated.
     * @param targetExtent Target extent for the duplicates of the elements.
     * @return List of duplicates.
     */
    public static List duplicateList(Collection list, JavaModelPackage targetExtent) {
        ArrayList result = new ArrayList();
        for (Iterator it = list.iterator(); it.hasNext();) {
            MetadataElement element = (MetadataElement) it.next();
            result.add(element.duplicate(targetExtent));
        }
        return result;
    }
    
    /** Unwraps JavaClass from ParameterizedType if applicable.
     * @param clazz JavaClass that can be a ParameterizedType.
     * @return JavaClass
     */
    public static JavaClass getRealClass(JavaClass clazz) {
        while (clazz instanceof ParameterizedType) {
            clazz = ((ParameterizedType) clazz).getDefinition();
        }
        return clazz;
    }
    
    /**
     * Checks if the passed type has any members.
     *
     * @param   type  type to be checked
     * @return  false if there is not any member, otherwise true
     */
    public static boolean hasMembers(JavaClass type) {
        for (Iterator it = type.getFeatures().iterator(); it.hasNext();) {
            Feature feature = (Feature) it.next();
            if (feature instanceof Field || feature instanceof Method || feature instanceof JavaClass) {
                return true;
            }
        }
        return false;
    }
}
