/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.*;


// RenameUsageElement used by RenameRefactoring .......................................................
public class RenameUsageElement extends WhereUsedElement {
    private String newName;
    private String oldName = null;

    public RenameUsageElement(RefObject jmiObject, Element feature, String newName) {
        super(jmiObject, feature);
        this.newName = newName;
    }

    public void performChange() {
        if (feature instanceof JavaClass) {
            JavaClass jc = (JavaClass) feature;
            if (changePart != null) {
                jc.setSuperClass((JavaClass) jmiObject);
            }
//                for (Iterator it = indexes.iterator(); it.hasNext();) {
//                    int index = ((Integer) it.next()).intValue();
//                    jc.getInterfaces().set(index, jmiObject);
//                }
        } else {
            if (feature instanceof Method) {
//                    Method m = (Method) feature;
//                    for (Iterator it = indexes.iterator(); it.hasNext();) {
//                        int index = ((Integer) it.next()).intValue();
//                        m.getExceptions().set(index, jmiObject);
//                    }
            } else
            if (feature instanceof ElementReference) {
                oldName = ((ElementReference) feature).getName();
                ((ElementReference) feature).setName(newName);
            } else if (feature instanceof Import) {
                Import imp = (Import) feature;
                String oldImp = imp.getName();
                int index = oldImp.lastIndexOf('.');
                String newImp = index > -1 ? oldImp.substring(0, index + 1) + newName : newName;
                imp.setName(newImp);
            }
//                if (ElementPartKindEnum.TYPE.equals(changePart)) {
//                    ((TypedElement) feature).setType((Type) jmiObject);
//                }
        }
    }

} // RenameUsageElement
