/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import org.netbeans.jmi.javamodel.ClassMember;

public class JavadocRenameElement extends JavadocElement {
    private String newName;
    private boolean enabled=true;
    private JavadocRenameElement previous;
    private boolean changePerformed;
    
    public JavadocRenameElement(int offset,String txt,ClassMember f,String name,JavadocRenameElement prev) {
        super(offset,txt,f);
        newName=name;
        previous=prev;
    }
    
    public void performChange() {
        StringBuffer newComment=new StringBuffer(feature.getJavadocText());
        int start=textoffset;
        
        if (previous!=null) {
            start+=previous.getDiff();
        }
        newComment.replace(start,start+text.length(),newName);
        feature.setJavadocText(newComment.toString());
        changePerformed=true;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean isEnabled) {
        enabled = isEnabled;
    }
    
    private int getDiff() {
        int diff=0;
        
        if (previous!=null) {
            diff=previous.getDiff();
        }
        if (changePerformed) {
            diff+=newName.length()-text.length();
        }
        return diff;
    }

}
