/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import java.text.MessageFormat;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.Position;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

/**
 *
 * @author  Tomas Hurka
 */
public class CreateMethodElement extends SimpleRefactoringElementImpl {
    private int modifiers;
    private String name;
    private TypeReference returnType;
    private String methodBody;
    private ClassDefinition declaringClass;
    private JavaModelPackage modelExtent;
    private List parameters;
    private Method newMethod;
    private PositionBounds bounds;
    private ClassMember insertPoint;
    
    /** Creates a new instance of CreateMethodElement */
    public CreateMethodElement(int mod,String n,TypeReference rdesc,List pars,String body,ClassMember insertPoint,ClassDefinition jcls, boolean enabled) {
        modifiers=mod;
        name=n;
        returnType=rdesc;
        parameters=pars;
        methodBody=body;
        declaringClass=jcls;
        this.insertPoint=insertPoint;
        modelExtent=(JavaModelPackage)jcls.refOutermostPackage();
        setEnabled(enabled);
    }
    
    /** Returns text describing the refactoring formatted for display (using HTML tags).
     * @return Formatted text.
     *
     */
    public String getDisplayText() {
        return new MessageFormat(NbBundle.getMessage(CreateMethodElement.class, "DSC_CreateMethod")).format (
                    new Object[] {name}
                );
    }
    
    /** Returns Java element associated with this refactoring element.
     * @return MDR Java element.
     *
     */
    public Element getJavaElement() {
        return declaringClass;
    }
    
    /** Returns position bounds of the text to be affected by this refactoring element.
     *
     */
    public PositionBounds getPosition() {
        if (bounds==null) {
            PositionBounds b=JavaMetamodel.getManager().getElementPosition(declaringClass);
            CloneableEditorSupport ed=b.getBegin().getCloneableEditorSupport();
            PositionRef start=ed.createPositionRef(0, Position.Bias.Forward);
            PositionRef end=ed.createPositionRef(0, Position.Bias.Backward);

            bounds=new PositionBounds(start,end);
        }
        return bounds;
    }
    
    /** Returns text describing the refactoring element.
     * @return Text.
     *
     */
    public String getText() {
        throw new UnsupportedOperationException();
    }
    
    /** Performs the change represented by this refactoring element.
     *
     */
    public void performChange() {
        if (isEnabled()) {
            MDRepository repository = JavaModel.getJavaRepository();
            repository.beginTrans(true);
            boolean fail = true;
            try {                
                newMethod=modelExtent.getMethod().createMethod(
                    name, null, modifiers, null, null, null, methodBody, null, parameters, null, null, 0
                );
                if (returnType==null)
                    newMethod.setType(modelExtent.getType().resolve("void")); //NOI18N
                else
                    newMethod.setTypeName((TypeReference)returnType.duplicate());
                List contents = declaringClass.getContents();
                if (insertPoint == null) {
                    contents.add(newMethod);
                } else {
                    ListIterator iter = contents.listIterator(contents.size());
                    Object obj;
                    do {
                        obj = iter.previous();
                    } while (obj != insertPoint);
                    iter.add(newMethod);
                }
                fail = false;
            }
            finally {
                repository.endTrans(fail);
            }
        }
    }
    
    public FileObject getParentFile() {
        return null;
    }
}
