/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;

public class CommentRenameFinder extends CommentFinder {
    String newName;
    ClassMember lastFeature;
    JavadocRenameElement lastElement;
    
    public CommentRenameFinder(Element el,String name) {
        super(el);
        newName=name;
    }
    
    protected RefactoringElementImplementation createNewElement(Resource rsc, int offset) {
        return new CommentRenameElement(offset,text,rsc,newName);
    }

    protected RefactoringElementImplementation createNewElement(ClassMember feature, int offset) {
        JavadocRenameElement prev=null;
        
        if (feature.equals(lastFeature)) {
            prev=lastElement;
        } else {
            lastFeature=feature;
        }
        return lastElement=new JavadocRenameElement(offset,text,feature,newName,prev);
    }
    
}
