/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DiffElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;

/**
 *
 * @author thurka
 */
public class CommentRenameElement extends CommentElement {
    private boolean enabled=true;
    private String newName;

    public CommentRenameElement(int offset, String txt, Resource rsc, String name) {
        super(offset,txt,rsc);
        newName=name;
    }
    
    public void performChange() {
        DiffElement diff=new DiffElement(textoffset,textoffset+text.length(),newName);
        
        ((ResourceImpl)resource).addExtDiff(diff);
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean isEnabled) {
        enabled = isEnabled;
    }
}
