/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;

public class CommentFinder {
    Element source;
    String text;
    Set allResources=null;
    int minindex=0;
    int maxindex=Integer.MAX_VALUE;

    public CommentFinder(Element el) {
        source=el;
        text=computeName();
        allResources=new HashSet();             
        if (((MetadataElement)el).isTransient() || el instanceof Parameter) {
            Feature f=JavaModelUtil.getDeclaringFeature(source);

            minindex=f.getStartOffset();
            maxindex=f.getEndOffset()-1;
        }
    }
    
    private String computeName() {
        String id;
        String fullPackageName=null;
        
        if (source instanceof JavaClass) {
            id=((JavaClass)source).getSimpleName();
        } else if (source instanceof JavaPackage) {
            fullPackageName=id=((JavaPackage)source).getName();
            int lastDot=id.lastIndexOf('.');
            
            if (lastDot!=-1)
                id=id.substring(lastDot+1);
        } else if (source instanceof Constructor) {
            id=((JavaClass)((Constructor)source).getDeclaringClass()).getSimpleName();
        } else
            id=((NamedElement)source).getName();
        return id;
    }
    
    public Collection searchCommentsInResource(Resource rsc) {
        
        if (rsc!=null && allResources.add(rsc)) {
            Collection items=searchJavaDocsInResource(rsc);

            if (rsc instanceof ResourceImpl) {
                items.addAll(searchInPlainComments((ResourceImpl)rsc));
            }
            return items;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection searchInPlainComments(ResourceImpl rsc) {
        String fullText=rsc.getSourceText();
 
        if (fullText!=null) {
            int offset=0;
            Collection items=new ArrayList(1);

            for (offset=0;offset<fullText.length();) {
                int fi=fullText.indexOf(text,offset);
                int end;

                if (fi==-1)
                    break;
                offset=fi+1;
                if (fi<minindex || fi>maxindex)
                    continue;
                if (fi!=0 && Character.isJavaIdentifierPart(fullText.charAt(fi-1)))
                    continue;
                end=fi+text.length();
                if (end<fullText.length() && Character.isJavaIdentifierPart(fullText.charAt(end)))
                    continue;
                if (!rsc.isComment(fi))
                    continue;
                items.add(createNewElement(rsc, fi));
            }
            return items;
        }        
        return Collections.EMPTY_LIST;        
    }
    
    private Collection searchJavaDocsInResource(Resource rsc) {
        Collection elements=new ArrayList(1);
        Iterator jIt=rsc.getClassifiers().iterator();

        while(jIt.hasNext()) {
            JavaClass jcls=(JavaClass)jIt.next();

            elements.addAll(searchText(jcls));
            elements.addAll(searchJavaDocsInJavaClass(jcls));
        }
        return elements;
    }
    
    private Collection searchJavaDocsInJavaClass(JavaClass jcls) {
        Iterator fIt=jcls.getContents().iterator();
        Collection elems=new ArrayList();
        
        while(fIt.hasNext()) {
            ClassMember f=(ClassMember)fIt.next();
            
            elems.addAll(searchText(f));
            if (f instanceof JavaClass) {
                elems.addAll(searchJavaDocsInJavaClass((JavaClass)f));
            }
        }
        return elems;
    }
    
    private Collection searchText(ClassMember f) {
        int javadocStart=f.getStartOffset();
        
        if (javadocStart>=minindex && javadocStart<=maxindex) {
            String docText=f.getJavadocText();
            
            if (docText!=null) {
                int offset=0;
                Collection items=new ArrayList(1);
                
                for (offset=0;offset<docText.length();) {
                    int fi=docText.indexOf(text,offset);
                    int end;

                    if (fi==-1)
                        break;
                    offset=fi+1;
                    if (fi!=0 && Character.isJavaIdentifierPart(docText.charAt(fi-1)))
                        continue;
                    end=fi+text.length();
                    if (end<docText.length() && Character.isJavaIdentifierPart(docText.charAt(end)))
                        continue;
                    items.add(createNewElement(f, fi));
                }
                return items;
            }
        }
        return Collections.EMPTY_LIST;
    }
    
    protected RefactoringElementImplementation createNewElement(ClassMember feature, int offset) {
        return new JavadocElement(offset,text,feature);
    }

    protected RefactoringElementImplementation createNewElement(Resource rsc, int offset) {
        return new CommentElement(offset,text,rsc);
    }
}
