/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import java.io.IOException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

/**
 *
 * @author Tomas Hurka
 */
public class CommentElement extends SimpleRefactoringElementImpl {
    Resource resource;
    Element javaElement;
    int textoffset;
    String text;
    private String plainText;
    private PositionBounds bounds = null;
    private String htmlText;
    
    public CommentElement(int offset,String txt,Resource rsc) {
        textoffset=offset;
        text=txt;
        resource=rsc;
        computeText();
    }

    public String getDisplayText() {
        return "// "+htmlText; // NOI18N
    }

    public Element getJavaElement() {
        if (javaElement==null) {
            javaElement=resource.getElementByOffset(textoffset);
            while (!(javaElement instanceof Feature) && !(javaElement instanceof Resource)) {
                javaElement = (Element) javaElement.refImmediateComposite();
            }
        }
        return javaElement;
    }

    public FileObject getParentFile() {
        return JavaModel.getFileObject(resource);
    }

    public PositionBounds getPosition() {
        if (bounds==null) {
            String commentText=resource.getSourceText();
            int lineNumber=-1;
            int offset,documentOffset;
            int column=0;
            DataObject dobj=JavaMetamodel.getManager().getDataObject(resource);
            EditorCookie editorCookie=(EditorCookie)dobj.getCookie(EditorCookie.class);
            StyledDocument doc = null;
            try {
                doc = editorCookie.openDocument();
            } catch (IOException ex) {
                ErrorManager.getDefault().notify(ex);
                return bounds;
            }
            DataEditorSupport support=(DataEditorSupport)dobj.getCookie(EditorCookie.class);
            PositionRef start,end;
            
            for (offset=0; offset<textoffset; lineNumber++,offset++) {
                column=textoffset-offset;
                offset=commentText.indexOf('\n',offset);
                if (offset == -1)
                    break;
            }
            documentOffset=NbDocument.findLineOffset(doc,lineNumber)+column;
            start=support.createPositionRef(documentOffset,Position.Bias.Forward);
            end=support.createPositionRef(documentOffset+text.length(),Position.Bias.Forward);
            bounds = new PositionBounds(start,end);
        }
        return bounds;
    }

    public String getText() {
        return plainText;
    }

    public void performChange() {
    }
    
    private void computeText() {
        String commentText=resource.getSourceText();
        int start=commentText.lastIndexOf('\n', textoffset);
        int end=commentText.indexOf('\n', textoffset);
        StringBuffer htmlBuffer=new StringBuffer();
        
        if (end==-1) end=commentText.length();
        
        htmlBuffer.append("<i>");//NOI18N
        htmlBuffer.append(CheckUtils.htmlize(commentText.substring(start+1, textoffset)));
        htmlBuffer.append("<b>");//NOI18N
        htmlBuffer.append(commentText.substring(textoffset, textoffset+text.length()));
        htmlBuffer.append("</b>");//NOI18N
        htmlBuffer.append(CheckUtils.trimToEnd(CheckUtils.htmlize(commentText.substring(textoffset+text.length(), end))));
        htmlBuffer.append("</i>");//NOI18N
        htmlText=htmlBuffer.toString();
        plainText=commentText.substring(start+1, end);
    }
    
}
