package org.netbeans.test.refactoring.cleanup;

import java.util.Collections;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.experimental.CleanUpRefactoring;
import org.netbeans.test.refactoring.experimental.Utility;

/**
 * @author leon chiver
 */
public class CleanUpRefactoringTest extends NbTestCase {

    public CleanUpRefactoringTest() {
        super(CleanUpRefactoringTest.class.getName());
    }
    
    private void executeTest(CleanUpRefactoring ref, String clazz, 
            String descr, String goldenFile) throws Exception {
        JavaClass jcls = Utility.findClass(clazz);
        Resource res = (Resource) jcls.refImmediateComposite();
        ref.setResources(Collections.singletonList(res));
        RefactoringSession rs = RefactoringSession.create(descr);
        Problem p = ref.prepare(rs);
        assertTrue("Fatal problem while preparing " + descr, p == null || !p.isFatal());
        assertNull("Problem while doing refactoring " + descr, rs.doRefactoring(true));
        assertFile(
                Utility.getFile(getDataDir(), clazz.replaceAll("\\.", "/") + ".java"),
                getGoldenFile(goldenFile), getWorkDir());
    }

    private CleanUpRefactoring createCompleteRefactoring() {
        CleanUpRefactoring ref = new CleanUpRefactoring();
        ref.setRemoveUnusedCallableFeatures(true);
        ref.setRemoveUnusedClasses(true);
        ref.setRemoveUnusedFields(true);
        ref.setRemoveUnusedLocalVars(true);
        ref.setRemoveUnusedImports(true);
        return ref;
    }
    
    public void testRemoveRedundantCasts() throws Exception {
        CleanUpRefactoring ref = new CleanUpRefactoring();
        ref.setRemoveRedundantCasts(true);
        executeTest(
                ref, 
                "org.netbeans.test.cleanup.RemoveRedundantCasts", 
                "remove redundant casts", 
                "testRemoveRedundantCasts.pass");
    }
    
    public void testRemoveUnusedElements() throws Exception {
        CleanUpRefactoring ref = createCompleteRefactoring();
        ref.setRemoveUnusedImports(false);
        executeTest(
                ref, 
                "org.netbeans.test.cleanup.RemoveUnusedElements", 
                "remove unused elements", 
                "testRemoveUnusedElements.pass");
    }
    
    public void testRemoveGenericsImports() throws Exception {
        CleanUpRefactoring ref = createCompleteRefactoring();
        executeTest(
                ref, 
                "org.netbeans.test.cleanup.RemoveGenericsImports", 
                "remove generics imports", 
                "testRemoveGenericsImports.pass");
    }
    
    public void testRemoveJavaLangImports() throws Exception {
        CleanUpRefactoring ref = createCompleteRefactoring();
        executeTest(
                ref, 
                "org.netbeans.test.cleanup.RemoveJavaLangImports", 
                "remove java.lang imports", 
                "testRemoveJavaLangImports.pass");
    }

    
    public void testRemoveRemovedElementsImports() throws Exception {
        CleanUpRefactoring ref = createCompleteRefactoring();
        executeTest(
                ref, 
                "org.netbeans.test.cleanup.RemoveRemovedElementsImports", 
                "remove removed elements imports", 
                "testRemoveRemovedElementsImports.pass");
    }
    
    public void testRemovePackageImports() throws Exception {
        CleanUpRefactoring ref = createCompleteRefactoring();
        executeTest(
                ref, 
                "org.netbeans.test.cleanup.RemovePackageImports", 
                "remove package imports", 
                "testRemovePackageImports.pass");
    }
    
    public void testRemoveSamePackageImports() throws Exception {
        CleanUpRefactoring ref = createCompleteRefactoring();
        executeTest(
                ref, 
                "org.netbeans.test.cleanup.RemoveSamePackageImports", 
                "remove same package imports", 
                "testRemoveSamePackageImports.pass");
    }
    
    public void testRemoveUnusedVariablesWithInitialValue() throws Exception {
        CleanUpRefactoring ref = createCompleteRefactoring();
        executeTest(
                ref,
                "org.netbeans.test.cleanup.RemoveUnusedWithInitialValue",
                "remove unused with initial value",
                "testRemoveUnusedWithInitialValue.pass");
    }
}
