/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.experimental.ui;

import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.MDRepository;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/**
 *
 * @author Daniel Prusa
 */
public class IntroduceVariableAction extends AbstractRefactoringAction {

    public IntroduceVariableAction() {
        super(NbBundle.getMessage(IntroduceVariableAction.class, "LBL_IntroduceVariableAction"), null);
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    protected RefactoringUI createRefactoringUI(Node[] nodes, org.netbeans.jmi.javamodel.Element selectedElement) {
        return new IntroduceVariableRefactoringUI(selectedElement, -1, -1);
    }
    
    protected RefactoringUI createRefactoringUI(Element selectedElement, int startOffset, int endOffset) {
        return new IntroduceVariableRefactoringUI(selectedElement, startOffset, endOffset);
    }
    
    protected boolean enabled(Node[] activatedNodes) {
        return true;
        /*
        if (activatedNodes.length != 1)
            return false;
        Element el = (Element) activatedNodes[0].getLookup().lookup(Element.class);
        return el instanceof BehavioralFeature;
         */
    }
    
    protected String iconResource () {
        return "org/netbeans/modules/refactoring/resources/refactoring.gif"; // NOI18N
    }

}
