/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Leon Chiver. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.experimental.ui;

import java.util.List;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.experimental.CleanUpRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;

/**
 * @author leon
 */
public class CleanUpRefactoringUI implements RefactoringUI {
    
    private CleanUpRefactoring refactoring;

    private List/*<Resource>*/ resources;
    
    private CleanUpPanel refactoringPanel;
    
    public CleanUpRefactoringUI(CleanUpRefactoring refactoring, List/*<Resource>*/ resources) {
        this.refactoring = refactoring;
        this.resources = resources;
    }
    
    public String getName() {
        return org.openide.util.NbBundle.getMessage(CleanUpRefactoringUI.class, "LBL_CleanUp");
    }
    
    public String getDescription() {
        return org.openide.util.NbBundle.getMessage(CleanUpRefactoringUI.class, "LBL_CleanUp");
    }
    
    public boolean isQuery() {
        return false;
    }
    
    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (refactoringPanel == null) {
            refactoringPanel = new CleanUpPanel(refactoring, resources);
        }
        return refactoringPanel;
    }
    
    public Problem setParameters() {
        refactoring.setResources(refactoringPanel.getSelectedResources());
        //
        refactoring.setRemoveUnusedImports(refactoringPanel.isRemoveUnusedImports());
        //
        refactoring.setRemoveRedundantCasts(refactoringPanel.isRemoveRedundantCasts());
        //
        refactoring.setRemoveUnusedFields(refactoringPanel.isRemoveUnusedFields());
        refactoring.setRemoveUnusedLocalVars(refactoringPanel.isRemoveUnusedLocalVars());
        refactoring.setRemoveUnusedCallableFeatures(refactoringPanel.isRemoveUnusedCallableFeatures());
        refactoring.setRemoveUnusedClasses(refactoringPanel.isRemoveUnusedClasses());
        refactoring.setCommentInsteadOfRemoving(refactoringPanel.isCommentInsteadOfRemoving());
        return refactoring.fastCheckParameters();
    }
    
    public Problem checkParameters() {
        return refactoring.checkParameters();
    }
    
    public boolean hasParameters() {
        return true;
    }
    
    public AbstractRefactoring getRefactoring() {
        return refactoring;
    }
    
    public HelpCtx getHelpCtx() {
        return null;
    }
    
}
