/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Leon Chiver. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.experimental.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.classpath.Util;
import org.netbeans.modules.refactoring.experimental.CleanUpRefactoring;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

/**
 * @author leon chiver
 */
public class CleanUpAction extends AbstractRefactoringAction {
    
    public CleanUpAction() {
        super(org.openide.util.NbBundle.getMessage(CleanUpAction.class, "LBL_CleanUp"), null);
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    protected boolean enabled(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        // TODO - enable the action for projects too
        for (int i = 0; i < activatedNodes.length; i++) {
            DataObject dataObj = (DataObject) activatedNodes[i].getCookie(DataObject.class);
            if (dataObj == null) {
                continue;
            }
            FileObject fo = dataObj.getPrimaryFile();
            if (Util.isUnderSourceRootOfOpenProjects(fo)) {
                return true;
            }
            if (Util.isClassPathRoot(fo)) {
                return true;
            }
        }
        return false;
    }

    protected RefactoringUI createRefactoringUI(Node[] nodes, Element selectedElement) {
        List/*<Resource>*/ resources = new ArrayList/*<Resource>*/();
        for (int i = 0; i < nodes.length; i++) {
            DataObject dataObject = (DataObject) nodes[i].getCookie(DataObject.class);
            if (dataObject instanceof JavaDataObject && 
                    ((JMManager) JavaMetamodel.getManager()).mergedCPContains(dataObject.getPrimaryFile())) {
                resources.add(JavaModel.getResource(dataObject.getPrimaryFile()));
                continue;
            } else if (dataObject instanceof DataFolder) {
                FileObject folder = dataObject.getPrimaryFile();
                try {
                    if (folder.getFileSystem() == Repository.getDefault().getDefaultFileSystem()) {
                        continue;
                    }
                    ClassPath cp = ClassPath.getClassPath(folder, ClassPath.SOURCE);
                    JavaPackage pkg = null;
                    if (cp != null) {
                        String packageName = cp.getResourceName(folder, '.', false);
                        FileObject root = cp.findOwnerRoot(folder);
                        if (root != null) {
                            pkg = JavaModel.getJavaExtent(root).getJavaPackage().resolvePackage(packageName);
                        }
                    }
                    if (pkg != null) {
                        addPackageResources(folder, resources, cp, true);
                    }
                } catch (FileStateInvalidException ex) {
                    // Ignore it
                }
            }
        }
        return new CleanUpRefactoringUI(new CleanUpRefactoring(), resources);
    }
        
    private void addPackageResources(FileObject obj, List resources, ClassPath cp, boolean recursively) {
        FileObject[] children = obj.getChildren();
        List/*<FileObject>*/ folders = new ArrayList/*<FileObject>*/();
        for (int i = 0; i < children.length; i++) {
            FileObject ch = children[i];
            if (!cp.contains(ch)) {
                continue;
            }
            boolean folder = ch.isFolder();
            if (folder) {
                folders.add(ch);
            } else if ("java".equals(ch.getExt())) { // NOI18N
                Resource res = JavaMetamodel.getManager().getResource(ch);
                if (res != null) {
                    resources.add(res);
                }
            }
        }
        if (recursively) {
            for (Iterator/*<FileObject>*/ it = folders.iterator(); it.hasNext();) {
                addPackageResources((FileObject) it.next(), resources, cp, true);
            }
        }
        
    }

    
}
