/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.experimental;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.classpath.Util;
import org.openide.filesystems.FileObject;

/** Copy Class Refactoring implementation class.
 *
 * @author Jan Becicka
 */
public final class CopyClassRefactoring extends AbstractRefactoring {
    
    private Resource resource;
    private FileObject targetFolder;
    private String targetPackageName;
    private String newName;
    
    /** Creates a new instance of CopyClassRefactoring 
     * @param sourceType Type the members of which should be pulled up.
     */
    public CopyClassRefactoring(Resource resource) {
        this.resource = resource;
    }
    
    protected void setClassPath() {
        // leave the complete classpath
        Util.setDefaultClassPath();
    }

    public Resource getResource() {
        return resource;
    }

    // --- PARAMETERS ----------------------------------------------------------
    
    public FileObject getTargetClassPathRoot() {
        return targetFolder;
    }

    public void setTargetClassPathRoot(FileObject targetFolder) {
        this.targetFolder = targetFolder;
    }
    
    public String getTargetPackageName() {
        return targetPackageName;
    }
    
    public void setTargetPackageName(String newName) {
        this.targetPackageName = newName;
    }
    
    public String getNewName() {
        return newName;
    }
    
    public void setNewName(String newName) {
        this.newName = newName;
    }
}
