/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.properties.syntax;


import org.openide.util.NbBundle;


/**
 * Options for the java editor kit
 *
 * @author Petr Jiricka, Libor Kramolis
 */
public class PropertiesPrintOptions extends org.netbeans.modules.editor.options.BasePrintOptions {

    /** Generated setial version UID. */
    static final long serialVersionUID =-1281317957713907843L;
    
    /** Name of property. */
    public static final String PROPERTIES = "properties"; // NOI18N

    
    /** Constructs properties options. */
    public PropertiesPrintOptions() {
        this(PropertiesKit.class, PROPERTIES);
    }

    /** Constructs properties options. */
    public PropertiesPrintOptions(Class kitClass, String typeName) {
        super(kitClass, typeName);
    }

    
    /** Gets localized string. 
     * @return localized string */
    protected String getString(String s) {
        try {
            String res = NbBundle.getBundle(PropertiesPrintOptions.class).getString(s);
            return (res == null) ? super.getString(s) : res;
        } catch (Exception e) {
            return super.getString(s);
        }
    }
}
