/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.properties;

import java.awt.event.KeyEvent;
import java.awt.event.KeyAdapter;
import java.awt.ContainerOrderFocusTraversalPolicy;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

import org.openide.util.NbBundle;


/**
 * Find panel for Resource Bundles table view component. GUI represenation only.
 *
 * @author  Peter Zavadsky
 */
public class FindPanel extends javax.swing.JPanel {
    
    /** Creates new form FindPanel. */
    public FindPanel() {
        initComponents ();
        initAccessibility ();
        findCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter() {
             public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\n') {
                    findButton.doClick(20);
                    evt.consume();
                }
            }
        });
    }

    private String getBundleString(String s){
        return NbBundle.getMessage(FindPanel.class, s);
    }

    // Accessor methods.
    
    /** Accessor to buttons. */
    public JButton[] getButtons() {
        return new JButton[] { findButton, cancelButton};
    }
    
    /** Accessor to combo box. */
    public JComboBox getComboBox() {
        return findCombo;
    }

    /** Accessor to highlight check box. */
    public JCheckBox getHighlightCheck() {
        return highlightCheck;
    }
    
    /** Accessor to match case check box. */
    public JCheckBox getMatchCaseCheck() {
        return matchCaseCheck;
    }
    
    /** Accessor to backward check box. */
    public JCheckBox getBackwardCheck() {
        return backwardCheck;
    }
    
    /** Accessor to wrap check box. */
    public JCheckBox getWrapCheck() {
        return wrapCheck;
    }
    
    /** Accessor to row check box. */
    public JCheckBox getRowCheck() {
        return rowCheck;
    }
    
    private void initAccessibility () {
        this.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_FindPanel"));
        
        findLabel.setDisplayedMnemonic((getBundleString("LBL_Find_Mnem")).charAt(0));
        findButton.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_Find"));
        rowCheck.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_SearchByRows"));
        wrapCheck.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_WrapSearch"));
        matchCaseCheck.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_MatchCaseCheck"));
        cancelButton.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_Cancel"));
        backwardCheck.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_BackwardCheck"));
        findCombo.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_FindCombo"));
        highlightCheck.getAccessibleContext().setAccessibleDescription(getBundleString("ACS_CTL_HighlightCheck"));
        
    }    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        findLabel = new javax.swing.JLabel();
        findCombo = new javax.swing.JComboBox();
        highlightCheck = new javax.swing.JCheckBox();
        matchCaseCheck = new javax.swing.JCheckBox();
        backwardCheck = new javax.swing.JCheckBox();
        wrapCheck = new javax.swing.JCheckBox();
        rowCheck = new javax.swing.JCheckBox();
        findButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setFocusCycleRoot(true);
        setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        findLabel.setLabelFor(findCombo);
        findLabel.setText(getBundleString("LBL_Find"));
        findLabel.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(findLabel, gridBagConstraints);

        findCombo.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 11, 0, 0);
        add(findCombo, gridBagConstraints);

        highlightCheck.setMnemonic((getBundleString("CTL_HighlightCheck_Mnem")).charAt(0));
        highlightCheck.setText(getBundleString("CTL_HighlightCheck"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 0);
        add(highlightCheck, gridBagConstraints);

        matchCaseCheck.setMnemonic((getBundleString("CTL_MatchCaseCheck_Mnem")).charAt(0));
        matchCaseCheck.setText(getBundleString("CTL_MatchCaseCheck"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(matchCaseCheck, gridBagConstraints);

        backwardCheck.setMnemonic((getBundleString("CTL_BackwardCheck_Mnem")).charAt(0));
        backwardCheck.setText(getBundleString("CTL_BackwardCheck"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 11, 0);
        add(backwardCheck, gridBagConstraints);

        wrapCheck.setMnemonic((getBundleString("CTL_WrapSearch_Mnem")).charAt(0));
        wrapCheck.setText(getBundleString("CTL_WrapSearch"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 0);
        add(wrapCheck, gridBagConstraints);

        rowCheck.setMnemonic((getBundleString("CTL_SearchByRows_Mnem")).charAt(0));
        rowCheck.setText(getBundleString("CTL_SearchByRows"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 11, 0, 0);
        add(rowCheck, gridBagConstraints);

        findButton.setText(getBundleString("CTL_Find"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(12, 11, 0, 11);
        add(findButton, gridBagConstraints);

        cancelButton.setText(getBundleString("CTL_Cancel"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 11, 0, 11);
        add(cancelButton, gridBagConstraints);

    }//GEN-END:initComponents

    public boolean requestFocusInWindow() {
        return findCombo.requestFocusInWindow();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox backwardCheck;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton findButton;
    private javax.swing.JComboBox findCombo;
    private javax.swing.JLabel findLabel;
    private javax.swing.JCheckBox highlightCheck;
    private javax.swing.JCheckBox matchCaseCheck;
    private javax.swing.JCheckBox rowCheck;
    private javax.swing.JCheckBox wrapCheck;
    // End of variables declaration//GEN-END:variables

}
