/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;

/**
 *
 * @author Jan Lahoda
 */
public class OpeningProjectPanel extends javax.swing.JPanel {
    
    private JComponent progress;
    
    /** Creates new form OpeningProjectPanel */
    public OpeningProjectPanel(ProgressHandle handle) {
        progress = ProgressHandleFactory.createProgressComponent(handle);
        initComponents();
        //#67914: On macosx, the background of JTextField is white even if non-editable:
        nameOfTheProject.setBackground(javax.swing.UIManager.getColor("Panel.background")); // NOI18N
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        innerPanel = new javax.swing.JPanel();
        nameOfTheProject = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(11, 11, 11, 11));
        jLabel1.setText(org.openide.util.NbBundle.getMessage(OpeningProjectPanel.class, "LBL_Opening_Projects", new Object[] {}));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 6);
        add(jLabel1, gridBagConstraints);

        innerPanel.setLayout(new java.awt.BorderLayout());

        innerPanel.add(progress, BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(innerPanel, gridBagConstraints);

        nameOfTheProject.setColumns(20);
        nameOfTheProject.setEditable(false);
        nameOfTheProject.setFont(javax.swing.UIManager.getFont("Label.font"));
        nameOfTheProject.setText("jTextField1");
        nameOfTheProject.setBorder(null);
        nameOfTheProject.setDisabledTextColor(javax.swing.UIManager.getColor("Label.foreground"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 0);
        add(nameOfTheProject, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JPanel innerPanel;
    public javax.swing.JLabel jLabel1;
    public javax.swing.JPanel jPanel1;
    public javax.swing.JTextField nameOfTheProject;
    // End of variables declaration//GEN-END:variables
    
    public void setProjectName(final String name) {
        nameOfTheProject.setText(name);
    }
}
