/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.util;

import java.util.ResourceBundle;
import junit.framework.TestCase;

/**
 * Test normal-mode functionality of {@link NbBundle}.
 * @author Jesse Glick
 */
public class NbBundleTest extends TestCase {
    
    public NbBundleTest(String name) {
        super(name);
    }
    
    public void testNormalMode() {
        doTestReadIntFromBundle(false);
    }
    
    static void doTestReadIntFromBundle(boolean debug) {
        ResourceBundle bundle = NbBundle.getBundle("org.openide.util.NbBundleTest");
        String val_secure = bundle.getString("INT_VALUE_SECURE");
        String val_insecure = bundle.getString("INT_VALUE_INSECURE");
        
        assertNotNull("Value from bundle not null", val_secure);
        assertNotNull("Value from bundle not null", val_insecure);
        
        if (debug) {
            assertTrue ("Values were read in debug mode.", val_insecure.indexOf (':') > 0);
        } else {
            assertFalse ("Values were read in normal mode.", val_insecure.indexOf (':') > 0);
        }
        
        try {
            assertEquals("Parsed as int", 123, Integer.parseInt(val_insecure));
        } catch (NumberFormatException nfe) {
            if (debug) {
                // OK, fine
            } else {
                // Not fine in normal mode!
                throw nfe;
            }
        }
        
        try {
            assertEquals("Parsed as int", 456, Integer.parseInt(val_secure));
        } catch (NumberFormatException nfe) {
            fail("Cannot throw NumberFormatException when read secure value.");
        }
        
    }
    
}
