/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.openide.util;

import org.openide.util.Lookup;

import javax.swing.Action;


/**
 * Interface which is supposed to be implemented by action which behaviour
 * is context dependent.
 * It means the created action (by method {@link #createContextAwareInstance}
 * is valid to the provided context, i.e. enablement status
 * and action performation is related to the context
 * (provided by the <code>Lookup</code>).
 * The context is typically <a href="@org-openide-windows@/org/openide/windows/TopComponent.html#getLookup()">TopComponent's context</a>.
 *
 * @author  Jaroslav Tulach, Peter Zavadsky
 *
 * @see org.openide.util.Utilities#actionsToPopup
 * @since 3.29
 */
public interface ContextAwareAction extends Action {
    /** Creates action instance for provided context. */
    public Action createContextAwareInstance(Lookup actionContext);
}
