/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.openide.util;

import java.awt.Cursor;
import java.lang.String;
import junit.textui.TestRunner;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;

/**
 *
 * @author Dafe Simonek
 */
public class UtilProgressCursorTest extends NbTestCase {
    
    /** Creates a new instance of UtilProgressCursorTest */
    public UtilProgressCursorTest(String testName) {
        super(testName);
    }

    public static void main(java.lang.String[] args) {
        TestRunner.run(new NbTestSuite(UtilProgressCursorTest.class));
    }
    
    public void testProgressCursor () {
        TopComponent testTc = new ProgressCursorComp();
        Cursor progressCursor = Utilities.createProgressCursor(testTc);
        testTc.setCursor(progressCursor);
        testTc.open();
        Cursor compCursor = testTc.getCursor();
        if (!progressCursor.equals(compCursor)) {
            fail("Setting of progress cursor don't work: \n" +
                 "Comp cursor: " + compCursor + "\n" +
                 "Progress cursor: " + progressCursor);
        }
    }
    
    /** testing component for setting cursor
     */
    private static class ProgressCursorComp extends TopComponent {
        
        public String getName () {
            return "TestProgressCursorComp";
        }
        
    }

}
