/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.openide.util;

import java.util.Collection;
import org.openide.util.enum.*;
import org.openide.util.enum.QueueEnumeration;

/** Implement factory methods from EnumerationsTest, shares the same tests
 * with EnumerationsTest.
 *
 * @author Jaroslav Tulach
 */
public class OldEnumerationsTest extends EnumerationsTest {
    
    /** Creates a new instance of EnumerationsTest */
    public OldEnumerationsTest (String testName) {
        super(testName);
    }

    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(new org.netbeans.junit.NbTestSuite(OldEnumerationsTest.class));
    }

    protected java.util.Enumeration singleton (Object obj) {
        return new SingletonEnumeration (obj);
    }    
    
    protected java.util.Enumeration convert (java.util.Enumeration en, final java.util.Map map) {
        return new AlterEnumeration (en) {
            protected Object alter (Object o) {
                return map.get (o);
            }
        };
    }    

    protected java.util.Enumeration removeDuplicates (java.util.Enumeration en) {
        return new RemoveDuplicatesEnumeration (en);
    }
    
    protected java.util.Enumeration removeNulls (java.util.Enumeration en) {
        return new FilterEnumeration (en);
    }
    
    protected java.util.Enumeration concat (java.util.Enumeration en1, java.util.Enumeration en2) {
        return new SequenceEnumeration (en1, en2);
    }
    
    protected java.util.Enumeration array (Object[] arr) {
        return new ArrayEnumeration (arr);
    }
    
    protected java.util.Enumeration filter (java.util.Enumeration en, final java.util.Set filter) {
        return new FilterEnumeration (en) {
            protected boolean accept (Object obj) {
                return filter.contains (obj);
            }
        };
    }
    protected java.util.Enumeration filter (java.util.Enumeration en, final QueueProcess filter) {
        en = new AlterEnumeration (en) {
            public Object alter (Object alter) {
                return filter.process (alter, null);
            }
        };
        
        return new FilterEnumeration (en);
    }
    
    protected java.util.Enumeration concat (java.util.Enumeration enumOfEnums) {
        return new SequenceEnumeration (enumOfEnums);
    }
    
    protected java.util.Enumeration empty () {
        return new EmptyEnumeration ();
    }
    
    protected java.util.Enumeration queue (Collection init, final QueueProcess process) {
        final java.util.HashMap diff = new java.util.HashMap ();
        
        class QEAdd extends QueueEnumeration implements Collection {
            protected void process (Object obj) {
                Object different = process.process (obj, this);
                if (different != obj) {
                    diff.put (obj, different);
                }
            }
            
            public boolean add (Object o) {
                put (o);
                return true;
            }
            
            public boolean addAll (Collection c) {
                put (c.toArray ());
                return true;
            }
            
            public void clear () {
                throw new IllegalStateException ("Unsupported");
            }
            
            public boolean contains (Object o) {
                throw new IllegalStateException ("Unsupported");
            }
            
            public boolean containsAll (Collection c) {
                throw new IllegalStateException ("Unsupported");
            }
            
            public boolean isEmpty () {
                throw new IllegalStateException ("Unsupported");
            }
            
            public java.util.Iterator iterator () {
                throw new IllegalStateException ("Unsupported");
            }
            
            public boolean remove (Object o) {
                throw new IllegalStateException ("Unsupported");
            }
            
            public boolean removeAll (Collection c) {
                throw new IllegalStateException ("Unsupported");
            }
            
            public boolean retainAll (Collection c) {
                throw new IllegalStateException ("Unsupported");
            }
            
            public int size () {
                throw new IllegalStateException ("Unsupported");
            }
            
            public Object[] toArray () {
                throw new IllegalStateException ("Unsupported");
            }
            
            public Object[] toArray (Object[] a) {
                throw new IllegalStateException ("Unsupported");
            }
        }
        QEAdd qe = new QEAdd ();
        qe.put (init.toArray ());
        
        class Change extends AlterEnumeration {
            public Change (java.util.Enumeration en) {
                super (en);
            }
            
            public Object alter (Object o) {
                if (diff.keySet ().contains (o)) {
                    return diff.remove (o);
                }
                return o;
            }
        }
        
        return new Change (qe);
    }
    
}
