/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.ErrorManager.Annotation;
import org.openide.util.Lookup;
import org.openide.util.Lookup.Result;
import org.openide.util.Lookup.Template;

/** A trivial implementation of Lookup and ErrorManager, so tests can be
 * run interactively without dying when Node logging calls ErrorManager.getDefault().
 *
 * @author  Tim Boudreau
 */
public class SimpleLookup extends Lookup {

    static {
        System.setProperty("org.openide.util.Lookup", "org.openide.explorer.propertysheet.SimpleLookup");
    }
    
    
    /** Creates a new instance of SimpleLookup */
    public SimpleLookup() {
    }
    
    ErrorManager em = null;
    public Object lookup(Class clazz) {
        if (clazz == ErrorManager.class) {
            if (em == null) {
                em = new SimpleErrorManager();
            }
            return em;
        }
        return null;
    }
    
    public Result lookup(Template template) {
        if (template.getType() == ErrorManager.class) {
            return new EMResult();
        }
        if (template.getType() == ClassLoader.class) {
            return new CLResult();
        }
        return null;
    }
    
    private class EMResult extends Lookup.Result {
        
        public void addLookupListener(org.openide.util.LookupListener l) {
        }
        
        public java.util.Collection allInstances() {
            return Arrays.asList(new ErrorManager[] {new SimpleErrorManager()});
        }
        
        public void removeLookupListener(org.openide.util.LookupListener l) {
        }
        
        public java.util.Set allClasses () {
            return new HashSet(Arrays.asList(new Class[] {ErrorManager.class}));
        }
        
    }
    
    private class CLResult extends Lookup.Result {
        
        public void addLookupListener(org.openide.util.LookupListener l) {
        }
        
        public java.util.Collection allInstances() {
            return Arrays.asList(new ClassLoader[] {getClass().getClassLoader()});
        }
        
        public void removeLookupListener(org.openide.util.LookupListener l) {
        }
        
    }
    
    private static Hashtable map = new Hashtable();
    private static final class SimpleErrorManager extends ErrorManager {
        private HashSet annotated = new HashSet();
        private HashMap annotatedExceptions = new HashMap();
        
        public Throwable annotate(Throwable t, int severity, String message, String localizedMessage, Throwable stackTrace, Date date) {
            System.err.println("Annotating exception " + t + " with " + localizedMessage);
            if (localizedMessage != null) {
                annotatedExceptions.put (t, localizedMessage);
            }
            return t;
        }

        public boolean isNotifiable (int severity) {
            return true;
        }
        
        public boolean isLoggable (int severity) {
            return true;
        }
        
        public Throwable attachAnnotations(Throwable t, Annotation[] arr) {
            System.err.println("attachAnnotations " + t);
            return t;
        }
        
        public Annotation[] findAnnotations(Throwable t) {
            System.err.println("findAnnotations for " + t);
            return new Annotation[0];
        }
        
        public ErrorManager getInstance(String name) {
            System.err.println("getInstance " + name);
            ErrorManager result = (ErrorManager) map.get(name);
            if (result  == null) {
                result = new SimpleErrorManager();
                map.put(name, result);
            }
            return result;
        }
        
        public void log(int severity, String s) {
            System.err.println(severity + ":" + s);
        }
        
        public void notify(int severity, final Throwable t) {
            System.err.println("Notify " + t + " thread " + Thread.currentThread());
            if (annotatedExceptions.get(t) != null) {
                //don't block the EQ
                Thread thr = new Thread(new Runnable() {
                    public void run() {
                        new TrivialExceptionDialog(t).show();
                    }
                });
                thr.run();
            }
            t.printStackTrace();
        }
        
        private class TrivialExceptionDialog extends JDialog {
            public TrivialExceptionDialog(Throwable t) {
//                super (Frame.getFrames()[0]);
                setModal(true);
                getContentPane().setLayout (new BorderLayout());
                JLabel lbl = new JLabel ((String) annotatedExceptions.get(t));
                JButton jb = new JButton("OK");
                getContentPane().add(lbl, BorderLayout.CENTER);
                getContentPane().add(jb, BorderLayout.SOUTH);
                getRootPane().setDefaultButton(jb);
                jb.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent ae) {
                        hide();
                        dispose();
                    }
                });
                pack();
            }
            
            public void processKeyEvent(java.awt.event.KeyEvent ke) {
                if (ke.getKeyCode() == ke.VK_ENTER) {
                    hide();
                }
            }
        }
    }
}
