/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *//*
 * NewSheetTest.java
 * NetBeans JUnit based test
 *
 * Created on July 14, 2003, 10:27 AM
 */

package org.openide.explorer.propertysheet;

import java.awt.Component;
import org.openide.*;
import org.openide.nodes.*;
import org.openide.explorer.propertysheet.editors.*;
import java.beans.*;
import java.lang.reflect.*;
import javax.swing.*;
import junit.framework.*;
import junit.textui.TestRunner;
import org.netbeans.junit.*;
import org.openide.nodes.NodeOperation;
import org.openide.util.Lookup;

/** Tests basic functionality of InplaceEditorFactory and its code to 
 *  correctly configure a property editor and associated InplaceEditor
 *  with the data encapsulated by a Node.Property.
 *
 * @author Tim Boudreau
 */

public class InplaceEditorFactoryTest extends NbTestCase {
    public InplaceEditorFactoryTest(String name) {
        super(name);
    }
   
    Component edComp = null;
    PropertyEditor ped = null;
    InplaceEditor ied = null;
    
    protected void setUp() throws Exception {
        PropUtils.forceRadioButtons=false;
        // Create new TestProperty
        tp = new TProperty("TProperty", true);
        // Create new TEditor
        te = new TagsEditor();
        
        try {
            ied = new InplaceEditorFactory(true, new ReusablePropertyEnv()).getInplaceEditor(tp, false);
            edComp = ied.getComponent();
            ped = ied.getPropertyEditor();
        }
        catch (Exception e) {
            fail("FAILED - Exception thrown "+e.getClass().toString());
        }        
    }
    
    public void testInplaceIsCombo() throws Exception {
        assertTrue ("Editor for tagged value not a combo box", edComp instanceof JComboBox);
    }
    
    public void testCorrectInplaceEditorValue() throws Exception {
        assertTrue ("InplaceEditor.getValue() returns " + ied.getValue() + " should be \"Value\"", "Value".equals(ied.getValue()));
    }
    
    public void testCorrectPropertyEditorValue() throws Exception {
        assertTrue ("PropertyEditor.getValue() returns " + ped.getValue() + " should be \"Value\"", "Value".equals(ped.getValue()));
    }
        
    // Property definition
    public class TProperty extends PropertySupport {
        private String myValue = "Value";
        // Create new Property
        public TProperty(String name, boolean isWriteable) {
            super(name, String.class, name, "", true, isWriteable);
        }
        // get property value
        public Object getValue() {
            return myValue;
        }
        // set property value
        public void setValue(Object value) throws IllegalArgumentException,IllegalAccessException, InvocationTargetException {
            Object oldVal = myValue;
            myValue = value.toString();
        }
        // get the property editor
        public PropertyEditor getPropertyEditor() {
            return te;
        }
    }
    
    public class TagsEditor extends PropertyEditorSupport implements ExPropertyEditor {
        PropertyEnv env;
        
        public TagsEditor() {
        }
        
        public String[] getTags() {
            return new String[] {"a","b","c","d","Value"};
        }
        
        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }
        
        public boolean supportsCustomEditor() {
            return false;
        }
        
        public void setValue(Object newValue) {
            super.setValue(newValue);
        }
    }
    
    public static void main(String args[]) {
         TestRunner.run(new NbTestSuite(InplaceEditorFactoryTest.class));
    }
    
    private TProperty tp;
    private TagsEditor te;
    private String initEditorValue;
    private String initPropertyValue;
    private String postChangePropertyValue;
    private String postChangeEditorValue;
}
