/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *//*
 * NewSheetTest.java
 * NetBeans JUnit based test
 *
 * Created on July 14, 2003, 10:27 AM
 */

package org.openide.explorer.propertysheet;

import java.awt.Component;
import org.openide.*;
import org.openide.nodes.*;
import org.openide.explorer.propertysheet.editors.*;
import java.beans.*;
import java.lang.reflect.*;
import javax.swing.*;
import javax.swing.JComponent;
import junit.framework.*;
import junit.textui.TestRunner;
import org.netbeans.junit.*;
import org.openide.nodes.NodeOperation;
import org.openide.util.Lookup;

/** Tests basic functionality of InplaceEditorFactory and its code to 
 *  correctly configure a property editor and associated InplaceEditor
 *  with the data encapsulated by a Node.Property.
 *
 * @author Tim Boudreau
 */

public class CustomInplaceEditorTest extends NbTestCase {
    public CustomInplaceEditorTest(String name) {
        super(name);
    }
   
    Component edComp = null;
    PropertyEditor ped = null;
    InplaceEditor ied = null;
    InplaceEditor ied2 = null;
    private static InplaceEditorFactory factory = new InplaceEditorFactory(true, new ReusablePropertyEnv());
    
    protected void setUp() throws Exception {
        // Create new TestProperty
        tp = new TProperty("TProperty", true);
        // Create new TEditor
        te = new TEditor();
        
        TProperty2 tp2 = new TProperty2("TProperty2", true);
        
        try {
            ied = factory.getInplaceEditor(tp, false);
            ied2 = factory.getInplaceEditor(tp2, false);
            edComp = ied.getComponent();
            ped = ied.getPropertyEditor();
        }
        catch (Exception e) {
            e.printStackTrace();
            fail("FAILED - Exception thrown "+e.getClass().toString());
        }        
    }
    
    public void testRegisterInplaceEditorViaPropertyEnv() throws Exception {
        assertTrue ("Inplace editor should be instance of test class registered by PropertyEnv.registerInplaceEditor, but is instance of " + ied.getClass(), ied instanceof TInplaceEditor);
    }
    
    public void testRegisterInplaceEditorViaHint() throws Exception {
        assertTrue ("Inplace editor should be instance of test class as returned by TProperty2.getValue(\"inplaceEditor\"), but is instance of " + ied2.getClass(), ied2 instanceof TInplaceEditor);
    }

    // Property definition
    public class TProperty2 extends PropertySupport {
        private Boolean myValue = Boolean.TRUE;
        // Create new Property
        public TProperty2(String name, boolean isWriteable) {
            super(name, Boolean.class, name, "", true, isWriteable);
        }
        // get property value
        public Object getValue() {
            return myValue;
        }
        
        public Object getValue (String key) {
            if ("inplaceEditor".equals(key)) {
                return new TInplaceEditor();
            } else {
                return super.getValue(key);
            }
        }
        
        // set property value
        public void setValue(Object value) throws IllegalArgumentException,IllegalAccessException, InvocationTargetException {
            myValue = (Boolean) value;
        }
    }
    
    // Property definition
    public class TProperty extends PropertySupport {
        private String myValue = "foo";
        // Create new Property
        public TProperty(String name, boolean isWriteable) {
            super(name, String.class, name, "", true, isWriteable);
        }
        // get property value
        public Object getValue() {
            return myValue;
        }
        // set property value
        public void setValue(Object value) throws IllegalArgumentException,IllegalAccessException, InvocationTargetException {
            Object oldVal = myValue;
            myValue = value.toString();
        }
        // get the property editor
        public PropertyEditor getPropertyEditor() {
            return te;
        }
    }
    
    public class TEditor extends PropertyEditorSupport implements ExPropertyEditor, InplaceEditor.Factory {
        PropertyEnv env;
        
        public TEditor() {
        }
        
        public void attachEnv(PropertyEnv env) {
            this.env = env;
            env.registerInplaceEditorFactory(this);
        }
        
        public boolean supportsCustomEditor() {
            return false;
        }
        
        public void setValue(Object newValue) {
            super.setValue(newValue);
        }
        
        public InplaceEditor getInplaceEditor() {
            return new TInplaceEditor();
        }
        
    }
    
    public class TInplaceEditor extends JComponent implements InplaceEditor {
        PropertyEditor pe=null;
        public void clear() {
        }
        
        public void connect(PropertyEditor pe, org.openide.explorer.propertysheet.PropertyEnv env) {
            this.pe = pe;
        }
        
        public JComponent getComponent() {
            return this;
        }
        
        public KeyStroke[] getKeyStrokes() {
            return null;
        }
        
        public PropertyEditor getPropertyEditor() {
            return pe;
        }
        
        public org.openide.explorer.propertysheet.PropertyModel getPropertyModel() {
            return null;
        }
        
        public Object getValue() {
            return null;
        }
        
        public void handleInitialInputEvent(java.awt.event.InputEvent e) {
        }
        
        public boolean isKnownComponent(Component c) {
            return false;
        }
        
        public void reset() {
        }
        
        public void setPropertyModel(org.openide.explorer.propertysheet.PropertyModel pm) {
        }
        
        public void setValue(Object o) {
        }
        
        public boolean supportsTextEntry() {
            return false;
        }
        
        public void addActionListener(java.awt.event.ActionListener al) {
        }
        
        public void removeActionListener(java.awt.event.ActionListener al) {
        }
        
    }
    
    public static void main(String args[]) {
         TestRunner.run(new NbTestSuite(CustomInplaceEditorTest.class));
    }
    
    private TProperty tp;
    private TEditor te;
    private String initEditorValue;
    private String initPropertyValue;
    private String postChangePropertyValue;
    private String postChangeEditorValue;
}
