/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.awt.peer.LightweightPeer;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashSet;

import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockUtils;
import org.openide.filesystems.FileLock;


/**
 * FileLockImplTest.java
 * JUnit based test
 *
 * @author Radek Matous
 */
public class WriteLockTest extends NbTestCase {    
    private File testFile = null;
    public WriteLockTest(String testName) {
        super(testName);
    }

    protected void setUp() throws java.lang.Exception {
        clearWorkDir();
        testFile = new File (getWorkDir(), "testLockFile.txt");        
        if (!testFile.exists()) {
            testFile.createNewFile();
        }

        assertTrue(testFile.exists());
    }

    public void testLightWeigtLock() throws Exception {
        testLightWeigtLockImpl(true);
        testLightWeigtLockImpl(false);
    }

    /**
     * Test of releaseLock method, of class org.netbeans.modules.masterfs.filebasedfs.filelocks.FileLockImpl.
     */
    public void testReleaseLock() throws Exception {
        testReleaseLockImpl(true);
        testReleaseLockImpl(false);        
    }
            
    /**
     * Test of isValid method, of class org.netbeans.modules.masterfs.filebasedfs.filelocks.FileLockImpl.
     */
    public void testIsValid() throws Exception {
        testIsValidImpl(true);
        testIsValidImpl(false);        
    }
    
    public void testAfterCrash() throws Exception {
        testAfterCrashImpl(true);
        testAfterCrashImpl(false);        
    }
    

    /**
     * Test of finalize method, of class org.netbeans.modules.masterfs.filebasedfs.filelocks.FileLockImpl.
     */
    public void testFinalize() throws Exception{        
        testFinalizeImpl(true);
        testFinalizeImpl(false);        
    }
    
    
    public void testLightWeigtLockImpl(boolean lightWeight) throws Exception {
        WriteLock lock = (WriteLock)WriteLockFactory.tryLock(testFile, lightWeight); 
        assertEquals(!lightWeight,lock.getLockFile().exists());
        lock.releaseLock();
        lock = (WriteLock)WriteLockFactory.tryLock(testFile, lightWeight); 
        assertEquals(!lightWeight,lock.getLockFile().exists());
        lock.releaseLock();
    }

    /**
     * Test of releaseLock method, of class org.netbeans.modules.masterfs.filebasedfs.filelocks.FileLockImpl.
     */
    public void testReleaseLockImpl(boolean lightWeight) throws Exception {
        FileLock lock = WriteLockFactory.tryLock(testFile, lightWeight); 
        assertNotNull(lock);
        try {
            WriteLockFactory.tryLock(testFile, lightWeight);
            fail ();
        } catch (IOException iex) {}
        
        lock.releaseLock();        
        lock.releaseLock();        
        lock = WriteLockFactory.tryLock(testFile, lightWeight);
        assertNotNull(lock);
        lock.releaseLock();        
    }
            
    /**
     * Test of isValid method, of class org.netbeans.modules.masterfs.filebasedfs.filelocks.FileLockImpl.
     */
    public void testIsValidImpl(boolean lightWeight) throws Exception {
        FileLock lock = WriteLockFactory.tryLock(testFile, lightWeight); 

        assertTrue(lock.isValid());
        lock.releaseLock();                
        assertFalse(lock.isValid());        
        
    }
    
    public void testAfterCrashImpl(boolean lightWeight) throws Exception {
        File lockFile = WriteLockUtils.getAssociatedLockFile(testFile);
        if (!lockFile.exists()) {
            assertTrue(lockFile.createNewFile());
        }
        assertTrue(lockFile.exists());
        FileLock lock = WriteLockFactory.tryLock(testFile, lightWeight);        
        try {
            assertNotNull(lock);
            assertTrue(lock.isValid());
            assertTrue(lockFile.exists());
        } finally {
            lock.releaseLock();
        }

    }
    

    /**
     * Test of finalize method, of class org.netbeans.modules.masterfs.filebasedfs.filelocks.FileLockImpl.
     */
    public void testFinalizeImpl(boolean lightWeight) throws Exception{        
        assertGC("",new WeakReference (WriteLockFactory.tryLock(testFile, lightWeight)));             
        FileLock lck = WriteLockFactory.tryLock(testFile, lightWeight);
        lck.releaseLock();
                
        File lockFile = WriteLockUtils.getAssociatedLockFile(testFile);
        assertFalse(lockFile.exists());
    }


    public java.io.File getWorkDir() throws java.io.IOException {
        return super.getWorkDir();
    }
    
    // TODO add test methods here. The name must begin with 'test'. For example:
    // public void testHello() {}
    
}
