/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import junit.framework.Test;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.masterfs.providers.AutoMountProvider;
import org.netbeans.modules.masterfs.providers.FileSystemProvider;
import org.netbeans.modules.masterfs.providers.ProvidedExtensionsTest;
import org.netbeans.modules.masterfs.providers.MountSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileObjectTestHid;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemFactoryHid;
import org.openide.filesystems.FileSystemTestHid;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.FileUtilTestHidden;
import org.openide.filesystems.URLMapperTestHidden;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/**
 * @author  rm111737
 */
public class MasterFileSystemTest extends FileSystemFactoryHid {
    private static MasterFileSystem masterfs;

    
    static {
        System.setProperty("org.openide.util.Lookup", TestLookup.class.getName());
    }

    /** Creates new MasterFileSystemTest */
    public MasterFileSystemTest(Test test) {
        super(test);
        ProvidedExtensionsTest.ProvidedExtensionsImpl.setImplsMoveRetVal(false);
        ProvidedExtensionsTest.ProvidedExtensionsImpl.setImplsRenameRetVal(false);
        ProvidedExtensionsTest.ProvidedExtensionsImpl.setImplsDeleteRetVal(false);        
    }


    public static void main(String args[]) {
        junit.textui.TestRunner.run(suite());
    }


    public static Test suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTestSuite(FileSystemTestHid.class);
        suite.addTestSuite(FileObjectTestHid.class);
        suite.addTestSuite(MasterFileObjectTestHid.class);        
        suite.addTestSuite(URLMapperTestHidden.class);
        suite.addTestSuite(FileUtilTestHidden.class);                        
        
         
        return new MasterFileSystemTest(suite);
    }


    private File getWorkDir() {
        String workDirProperty = System.getProperty("workdir");//NOI18N
        workDirProperty = (workDirProperty != null) ? workDirProperty : System.getProperty("java.io.tmpdir");//NOI18N                 
        return new File(workDirProperty);
    }

    protected String getResourcePrefix(String testName, String[] resources) {
       try {
           masterfs = MasterFileSystem.getDefault();
           File testDir = getWorkDir();
           createResources(testDir, resources);
           return FileUtil.normalizeFile(testDir).getAbsolutePath().replace('\\','/');
        } catch (IOException e) {
            throw new IllegalStateException(e.getLocalizedMessage());
        } 
    }

    private void createResources(File testDir, String[] resources) throws IOException {
        for (int i = 0; i < resources.length; i++) {
            File resourceFile = FileUtil.normalizeFile(new File (testDir, resources[i]));
            String resourcePath = resourceFile.getAbsolutePath().replace('\\','/');
            if (masterfs.getRoot().getFileObject(resourcePath) == null) {
                boolean isFolder = resources[i].endsWith("/");
                try {
                    createOneResource(isFolder, resourcePath);
                } catch (IOException e) {
                    /** this piece of code handles clearWorkDir in TetsBaseHid.setUp. MasterFileSystem is singleton
                     * shared in one JVM for all tests and clearWorkDir means external modification here.*/
                    StringTokenizer en = new StringTokenizer(resourcePath, "/");
                    FileObject lastFo = masterfs.getRoot();
                    while (en.hasMoreElements() && lastFo != null) {
                        String filename = (String) en.nextElement();
                        if (lastFo.getFileObject(filename) == null) {
                            lastFo.refresh();
                        }
                        lastFo = lastFo.getFileObject(filename);                        
                    }
                    createOneResource(isFolder, resourcePath);
                }
            }
        }
    }

    private void createOneResource(boolean folder, String resourcePath) throws IOException {
        if (folder) {
            FileUtil.createFolder(masterfs.getRoot(), resourcePath);
        } else {
            FileUtil.createData(masterfs.getRoot(), resourcePath);                    
        }
    }

    protected FileSystem[] createFileSystem(String testName, String[] resources) throws IOException {        
        return new FileSystem[]{masterfs};
    }

    protected void destroyFileSystem(String testName) throws IOException {}
    
    static class TestFSProvider implements FileSystemProvider {
        static TestFSProvider DEFAULT = new TestFSProvider();        
        private boolean init = false;
        
        private TestFSProvider () {};
        
        public AutoMountProvider initialize(MountSupport mSupport) {
            init = true;
            return null;
        }
        
        boolean isInitailized () {
            return init;
        }
    }
    
    public static class TestLookup extends ProxyLookup {
        public TestLookup() {
            super ();
            setLookups(new Lookup[] {getMetaInfLookup(), getInstanceLookup()});                
        }

        private Lookup getInstanceLookup() {
            InstanceContent instanceContent = new InstanceContent ();
            instanceContent.add(TestFSProvider.DEFAULT);
            Lookup instanceLookup = new AbstractLookup (instanceContent);
            return instanceLookup;
        }

        private Lookup getMetaInfLookup() {
            return Lookups.metaInfServices(Thread.currentThread().getContextClassLoader());
        }
    }
    
}
