/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs;

import java.io.File;
import junit.framework.Test;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

/**
 * @author pzajac
 */
public class Deadlock54741 extends NbTestCase {
    
    private static class DelFileChangeListener implements FileChangeListener {
        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            try {
                synchronized (this) {
                    wait(); 
                }
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }
        
    }
    
    private static class DeleteRunnable implements Runnable {
        FileObject fo;
        public DeleteRunnable(FileObject fo) {
            this.fo = fo;
        }
        public void run() {
            System.out.println("start delete");
            try {
               fo.getFileSystem().addFileChangeListener(new DelFileChangeListener());
               FileSystem fs = fo.getFileSystem(); 
               FileUtil.toFile(fo).delete();
               fs.refresh(true);
            } catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("end delete");
        } 
    }
    
    static {
        System.setProperty("org.openide.util.Lookup", MasterFileSystemTest.TestLookup.class.getName());
    }
    
    public Deadlock54741(String testName) {
        super(testName);
    }
    
    public void testDeadLock () throws Exception {
        File f = File.createTempFile("fff","fsdfsd");
        FileObject tmpFo = FileUtil.toFileObject(f.getParentFile()); 
        assertNotNull(tmpFo);
      
        FileObject fo = null;
        fo = tmpFo.createData("ssss");   
        Runnable deleteRunnable = new DeleteRunnable(fo); 
        Thread thread = new Thread(deleteRunnable);
        thread.start();
            
        try {
            Thread.currentThread().sleep(2000);
            boolean isDeadlock [] = new boolean[1]; 
             makeDeadlock(tmpFo,f, isDeadlock);   
            Thread.sleep(2000);
            boolean isD = isDeadlock[0];
            // finish -> unlock thread
            deleteRunnable.notify();
            assertFalse("deadlock!!!",isD);    
        } catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        
    }
    private Thread makeDeadlock(final FileObject fo, final File f,final boolean isDeadLock[]) {  
        isDeadLock[0] = true;
        Thread t = new Thread () {
            public void run() {
                   fo.getFileObject(f.getName());
                   isDeadLock[0] = false;
        }};     
        t.start(); 
        return t;  
    }  
        
    public static Test suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTestSuite(Deadlock54741.class);
         
        return new MasterFileSystemTest(suite);
    }
}
