/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs.providers;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.IOException;
import org.openide.filesystems.FileSystem;

/**
 * An object that implements AutoMountProvider is called from MasterFileSystem and can affect
 * behaviour of MasterFileSystem. MasterFileSystem invokes individual AutoMountProviders to obtain
 * instance of FileSystem for defined mount point (see {@link #createFileSystem}).
 * If there exists at least one implementation of AutoMountProvider, which returns non null FileSystem,
 * then such FileSystem is mounted into MasterFileSystem. This mechanism can be called <b>automatic mounting</b>.
 *
 * So, AutoMountProvide must implement logic where (which mount point) and what to mount
 * (which FileSystem implementation) into MasterFileSystem.
 *
 * @see org.netbeans.modules.masterfs.providers.FileSystemProvider#initialize
 * @see org.netbeans.modules.masterfs.providers.MountSupport
 * @author  rm111737
 */
public abstract class AutoMountProvider {
    /** Provides filesystem with root defined by mountPoint or return null.
     * If method method isRootOfFileSystem returns false for the same mountPoint,
     * then method createFileSystem must return null.
     * And if method isRootOfFileSystem returns true, then method createFileSystem mustn't return null.
     * @param mountPoint corresponds to java.io.File.getAbstractPath
     * But be aware, that this doesn't mean, that such file must really exist.
     * mountPoint may also address virtual location.
     * @return instance of FileSystem or null. FileObject hierarchy within a delegate FileSystem
     *  must precisely match the File hierarchy and must not hide any files which exist on disk.
     */
    public abstract FileSystem createFileSystem (String mountPoint) throws IOException, PropertyVetoException ;

    /**
     * If method method isRootOfFileSystem returns false for the same mountPoint,
     * then method createFileSystem must return null.
     * And if method isRootOfFileSystem returns true, then method createFileSystem mustn't return null.
     * @param mountPoint corresponds to java.io.File.getAbstractPath
     * But be aware, that this doesn't mean, that such file must really exist.
     * mountPoint may also address virtual location.
     * @return true if mountPoint is expected to be root of  FileSystem, that provides
     * method {@link #createFileSystem}
     */
    public abstract boolean isRootOfFileSystem (String mountPoint);

    /**
     * Gets icon for filesystem with root defined by mountPoint or null. Null can be
     * returned only if method isRootOfFileSystem returns false for the same mountPoint.
     * @param mountPoint corresponds to java.io.File.getAbstractPath
     * But be aware, that this doesn't mean, that such file must really exist.
     * mountPoint may also address virtual location.
     * @param iconType constant to indicate icon (@see BeanInfo)
     * @return filesystem icon for filesystem with root defined by mountPoint or null
     */
    public Image getIcon (String mountPoint, int iconType) {
        return null;
    }

}
