/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.openide.filesystems.FileLock;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;


/**
 * @author Radek Matous
 */
public final class WriteLockFactory {
    public static synchronized FileLock tryLock(final File file, boolean lightWeight) throws IOException {
        boolean isLockFile = WriteLockUtils.hasActiveLockFileSigns(file.getAbsolutePath());
        if (isLockFile) {
            IOException toFire = new IOException(file.getAbsolutePath());
            FSException.annotateException(toFire);
            throw toFire;
        }
        
        return (lightWeight) ? WriteLock.tryLightWeightLock(file) : 
            ((isNioLockingEnabled()) ? WriteLock.tryNioLock(file) : WriteLock.tryLock(file));
    }

    private static boolean isNioLockingEnabled() {
        //TODO: probably according to property 
        return false;
    }
    
    private WriteLockFactory(){}    
}
