/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs;

import org.openide.filesystems.FileSystem;

import java.io.IOException;

/**
 *
 * @author  rm111737
 */
public interface InternalMountSupport {
    /**
     * Attaches the file system	at the directory or file defined by parameter mountPoint.
     *
     * @param mountPoint, that corresponds to java.io.File.getAbstractPath
     * @param fs filesystem that should be attached
     * @exception IOxception when mount fails     */
    public abstract void mount(String mountPoint, FileSystem fs) throws IOException;

    /**
     * Detaches the filesystem
     *
     * @param fs filesystem, taht should be unmounted
     * @exception IOxception when unmount fails
     */
    public abstract void unmount(FileSystem fs) throws IOException;

}
