/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.loaders;

import java.io.PrintStream;
import javax.swing.Action;
import junit.textui.TestRunner;
import org.netbeans.junit.*;
import org.openide.DialogDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.*;
import org.openide.util.actions.SystemAction;

/** DefaultDataObject is supposed to have open operation that shows the text
 * editor or invokes a dialog with questions.
 *
 * @author  Jaroslav Tulach
 */
public final class DefautDataObjectHasOpenActionTest extends NbTestCase {
    
    private FileSystem lfs;
    private DataObject obj;
    
    /** Creates a new instance of DefaultSettingsContextTest */
    public DefautDataObjectHasOpenActionTest(String name) {
        super(name);
    }
    
    protected void setUp() throws java.lang.Exception {
        super.setUp();
        
        // initialize modules
        org.openide.util.Lookup.getDefault().lookup(org.openide.modules.ModuleInfo.class);
        
        String fsstruct [] = new String [] {
            "AA/a.test"
        };
        
        TestUtilHid.destroyLocalFileSystem(getName());
        lfs = TestUtilHid.createLocalFileSystem(getWorkDir(), fsstruct);
        org.openide.filesystems.Repository.getDefault ().addFileSystem (lfs);
        
        FileObject fo = lfs.findResource("AA/a.test");
        assertNotNull("file not found", fo);
        obj = DataObject.find(fo);
        
        assertEquals ("The right class", obj.getClass (), DefaultDataObject.class);

        assertFalse ("Designed to run outside of AWT", javax.swing.SwingUtilities.isEventDispatchThread ());
    }
    
    protected void tearDown() throws java.lang.Exception {
        super.tearDown();
        org.openide.filesystems.Repository.getDefault ().removeFileSystem (lfs);
    }

    public void testOpenActionIsAlwaysFirst () throws Exception {
        org.openide.nodes.Node n = obj.getNodeDelegate();
        
        assertEquals (
            "Open action is the default one", 
            org.openide.actions.OpenAction.get (org.openide.actions.OpenAction.class),
            n.getPreferredAction()
        );
        
        Action[] actions = n.getActions (false);
        assertTrue ("There are some actions", actions.length > 1);
        
        assertEquals (
            "First one is open",
            org.openide.actions.OpenAction.get (org.openide.actions.OpenAction.class),
            actions[0]
        );
        
        assertNull (
            "Then there is a separator",
            actions[1]
        );
    }



}
