/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.loaders;

import java.lang.ref.WeakReference;
import java.util.*;
import junit.textui.TestRunner;
import org.openide.filesystems.FileSystem;
import java.util.Enumeration;
import org.openide.nodes.Node;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.Repository;
import org.netbeans.junit.*;
import org.openide.filesystems.*;

/** Creation of data object is said to be slow due to
 * poor implementation of BrokenDataShadow validate functionality.
 * @author Jaroslav Tulach
 */
public class DataShadowBrokenSlownessTest extends NbTestCase {
    /** List of DataObject */
    private List shadows, brokenShadows;
    /** folder to work with */
    private DataFolder folder;
    /** fs we work on */
    private FileSystem lfs;
    /** keep some files */
    private FileObject[] arr;
    
    public DataShadowBrokenSlownessTest (String name) {
        super(name);
    }
    
    public static NbTestSuite suite () {
        return NbTestSuite.speedSuite (DataShadowBrokenSlownessTest.class, 10, 5);
    }
    
    protected void setUp() throws Exception {
        clearWorkDir();
        lfs = TestUtilHid.createLocalFileSystem(getWorkDir (), new String[] {
            "shadows/",
            "brokenshadows",
            "folder/original.txt",
            "folder/orig.txt",
            "modify/"
        });
        Repository.getDefault ().addFileSystem (lfs);
        
        int count = getTestNumber ();
        
		shadows = createShadows (
            DataObject.find (lfs.findResource("folder/original.txt")), 
            DataFolder.findFolder (lfs.findResource ("shadows")),
            count
        );
        
		brokenShadows = /*Collections.EMPTY_LIST; */createShadows (
            DataObject.find (lfs.findResource("folder/orig.txt")), 
            DataFolder.findFolder (lfs.findResource ("shadows")),
            count
        );
        
        DataObject.find (lfs.findResource("folder/orig.txt")).delete ();
        
        ListIterator it = brokenShadows.listIterator ();
        while (it.hasNext ()) {
            DataObject obj = (DataObject)it.next ();
            assertFalse ("Is not valid", obj.isValid ());
            assertTrue ("Used to be shadow", obj instanceof DataShadow);
            DataObject newObj = DataObject.find (obj.getPrimaryFile ());
            assertTrue ("They are different", newObj != obj);
            assertFalse ("It is not shadow, as it is broken", newObj instanceof DataShadow);
            
            it.set (newObj);
        }
        
        FileObject files = lfs.findResource ("modify");
        for (int i = 0; i < 200; i++) {
            FileUtil.createData (files, "empty" + i + ".txt");
        }
        
        arr = files.getChildren ();
        assertEquals ("Children created", 200, arr.length);
        
        folder = DataFolder.findFolder (files);
    }
    
    private static List createShadows (DataObject original, DataFolder target, int count) throws java.io.IOException {
        ArrayList list = new ArrayList (count);
        for (int i = 0; i < count; i++) {
            DataShadow shad = DataShadow.create(target, original.getName()+i, original, "shadow");
            list.add (shad);
        }
        return list;
    }
    
    protected void tearDown() throws Exception {
        Repository.getDefault ().removeFileSystem (lfs);

        DataShadow.waitUpdatesProcessed();
        
        WeakReference ref = new WeakReference(lfs);
        this.lfs = null;
        this.brokenShadows = null;
        this.folder = null;
        this.shadows = null;
        this.arr = null;
        assertGC("Make sure the filesystem is gone", ref);
    }
    public void test0 () throws java.io.IOException {
        folder.delete ();
    }

    public void test10 () throws java.io.IOException {
        folder.delete ();
    }
    
    public void test99 () throws java.io.IOException {
        folder.delete ();
    }

    public void test245 () throws java.io.IOException {
        folder.delete ();
    }
    public void test987 () throws java.io.IOException {
        folder.delete ();
    }
}
