/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * PsSettings.java
 *
 * Created on January 13, 2004, 5:38 PM
 */

package org.netbeans.modules.openide.explorer;

import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;

/** Non-public settings storage for a few trivial settings the
 * property sheet needs to store.  Should be migrated to use
 * registry and eliminate this class for post 3.6 - for now,
 * this will do.  See <a href="http://www.netbeans.org/issues/show_bug.cgi?id=36157">
 * issuezilla issue 36157</a> for details.
 *
 * @author  Tim Boudreau */
public abstract class PsSettings {
    protected PsSettings() {}
    private static PsSettings defaultInstance = null;
    /** Get the default instance of PropertySheetSettings */
    public static PsSettings getDefault() {
        if (defaultInstance == null) {
            defaultInstance = (PsSettings) 
                Lookup.getDefault().lookup(PsSettings.class);
            if (defaultInstance == null) {
                defaultInstance = new Trivial();
            }
        }
        return defaultInstance;
    }
    
    public abstract int getInt (String key, int defaultValue);
    
    public abstract void putInt (String key, int value);
    
    public abstract void putBoolean (String key, boolean value);
    
    public abstract boolean getBoolean (String key, boolean defaultValue);
    
    public abstract void put (String key, String value);
    
    public abstract String get (String key, String defaultValue);

    private static class Trivial extends PsSettings {
        private Map map = new HashMap();
        public String get(String key, String defaultValue) {
            String result = (String) map.get(key);
            if (result == null) {
                result = defaultValue;
            }
            return result;
        }
        
        public boolean getBoolean(String key, boolean defaultValue) {
            Boolean result = (Boolean) map.get(key);
            if (result == null) {
                return defaultValue;
            } else {
                return result.booleanValue();
            }
        }
        
        public int getInt(String key, int defaultValue) {
            Integer i = (Integer) map.get(key);
            if (i == null) {
                return defaultValue;
            }
            return i.intValue();
        }
        
        public void put(String key, String value) {
            map.put(key, value);
        }
        
        public void putBoolean(String key, boolean value) {
            map.put (key, value ? Boolean.TRUE : Boolean.FALSE);
        }
        
        public void putInt(String key, int value) {
            map.put (key, new Integer(value));
        }
        
    }
}
