/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.nbbuild;

import org.apache.tools.ant.*;
import org.apache.tools.ant.types.*;
import java.util.StringTokenizer;
import java.io.File;
import java.util.Iterator;
import java.util.Hashtable;
import java.util.Vector;

/**
 * @author Michal Zlamal
 */
public class CheckClustersContent extends Task {
    private String clustersName = null;
    private File trackingPath = null;
    private File kitDir = null;
    private Vector excludes = new Vector();

    /** List of clusters to test */
    public void setClusters( String clusters ) {
        this.clustersName = clusters;
    }
    
    public void setTrackingPath( File path ) {
        this.trackingPath = path;
    }
    
    public void setKitDestDir( File kitDir ) {
        this.kitDir = kitDir;
    }
    
    public Exclude createExclude() {
        Exclude ex = new Exclude();
        excludes.add(ex);
        return ex;
    }
    
    public void execute() throws BuildException {
        if (clustersName == null) {
            throw new BuildException("Cluster property must be set", getLocation());
        }
        if (trackingPath == null) {
            throw new BuildException("Path to module_tracking.xml file must be set.", getLocation());
        }
        Hashtable listOfFiles = new Hashtable();
        
        StringTokenizer clusterTokens = new StringTokenizer(clustersName, " \t\n\f\r,");
        boolean error = false;
        String message = "";
        while (clusterTokens.hasMoreTokens()) {
            String clusterName = clusterTokens.nextToken();
            String clusterList = this.getProject().getProperty(clusterName);
            if (clusterList == null) {
                throw new BuildException("Cluster " + clusterName + " doesn't exist", getLocation());
            }
            ModuleTracking tracking = new ModuleTracking(trackingPath.getAbsolutePath());
            StringTokenizer moduleTokens = new StringTokenizer(clusterList, " \t\n\f\r,");
            while (moduleTokens.hasMoreTokens()) {
                String module = moduleTokens.nextToken();
                String path = tracking.getModulePath(module);
                Iterator files = tracking.getFilesForModule(module);
                if (files==null) {
                    log("This module doesn't have module tracking info: " + module, Project.MSG_INFO);
                    continue;
                }
                while (files.hasNext()) {
                    // Slash "/" is intentional as all tracking files now contain "/" as file separators
                    String file = path.replace(File.separatorChar, '/') + '/' + ((String)files.next()).replace(File.separatorChar, '/'); //NOI18N
                    if (listOfFiles.containsKey(file)) {
                        error = true;
                        message += "\nThe file: " + file + " from module: " + module + " is also in module: " + listOfFiles.get(file);
                    }
                    listOfFiles.put(file,module);
                }
            }
        }
        FileSet fileset = new FileSet();
        fileset.setDir(kitDir);
        if (excludes.size() > 0) {
            Iterator it = excludes.iterator();
            while (it.hasNext()) {
                Exclude ex = (Exclude) it.next();
                fileset.createExclude().setName(ex.getName());
            }
        }
        DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
        ds.scan();
        String included[] = ds.getIncludedFiles();
        for (int i = 0; i < included.length; i++)
            if (!listOfFiles.containsKey(included[i].replace(File.separatorChar, '/'))) {
                error = true;
                message += "\nThe file: " + included[i] + " isn't included in any module's NBM";
            }
        if (error)
            throw new BuildException("Check of content of clusters and NBMs FAILED because of those issues:" + message, getLocation());
    }
    
    public class Exclude {
        String name = null;
        public void setName(String name) {
            this.name = name;
        }
        public String getName() {
            return name;
        }
    }
}
