/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.util.*;

import junit.extensions.*;
import junit.framework.*;

import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;

import org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl;
import org.netbeans.mdr.persistence.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 * Multivalued index test case.
 */
public class UniqueIndexTest extends MDRTestCase {

    public static final String KEY_STR = "key_";
    public static final String VAL_STR = "value_";
    
    public UniqueIndexTest(String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (UniqueIndexTest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
//                org.netbeans.mdr.handlers.BaseObjectHandler.setDefaultClassLoader (this.getClass ().getClassLoader ());
            }
            public void tearDown () {
            }
        };
        return setup;
    }
    
    public void test () throws Exception {
        StorageFactoryImpl factory = new StorageFactoryImpl();
        Map map = new HashMap();
        map.put(StorageFactoryImpl.STORAGE_ID, "UniqueIndexTestStorage");
        Storage storage = factory.createStorage(map);
        MultivaluedIndex uniIndex = storage.createMultivaluedIndex("index_1", Storage.EntryType.STRING, Storage.EntryType.STRING, true);
        MultivaluedIndex index = storage.createMultivaluedIndex("index_2", Storage.EntryType.STRING, Storage.EntryType.STRING, false);
        MultivaluedOrderedIndex uniOrderedIndex = storage.createMultivaluedOrderedIndex("index_3", Storage.EntryType.STRING, Storage.EntryType.STRING, true);
        boolean failed;
        
        for (int x = 0; x < 10; x++) {
            String key = KEY_STR + x;
            for (int y = 0; y < 10; y++) {
                String value = VAL_STR + y;
                uniIndex.add(key, value);
                index.add(key, value);
                uniOrderedIndex.add(key, value);
            }
        }
        
        String key = KEY_STR + 2;
        String value = VAL_STR + 4;
        int pos = 4;
        
        failed = false;
        try {
            uniIndex.add(key, value);
        } catch (StorageBadRequestException e) {
            failed = true;
        }
        if (!failed)
            fail();
        
        failed = false;
        try {
            uniOrderedIndex.add(key, value);
        } catch (StorageBadRequestException e) {
            failed = true;
        }
        if (!failed)
            fail();
        
        // should not fail
        index.add(key, value);
        uniIndex.remove(key, value);
        uniOrderedIndex.remove(key, value);
        uniIndex.add(key, value);
        uniOrderedIndex.add(key, pos, value);
        uniOrderedIndex.replace(key, pos, value);
        
        failed = false;
        try {
            uniOrderedIndex.replace(key, 1, value);
        } catch (StorageBadRequestException e) {
            failed = true;
        }
        if (!failed)
            fail();
        
        Collection coll_1 = uniIndex.getItems(key);
        coll_1.add(VAL_STR + 20);
        coll_1.remove(VAL_STR + 20);
        List coll_2 = uniOrderedIndex.getItemsOrdered(key);
        coll_2.add(VAL_STR + 20);
        coll_2.remove(VAL_STR + 20);
        
        failed = false;
        try {
            coll_2.set(7, value);
        } catch (RuntimeStorageException e) {
            failed = true;
        }
        if (!failed)
            fail();
        
        ListIterator iter = coll_2.listIterator();
        iter.add(VAL_STR + 11);
        iter.next();
        iter.remove();
        iter.next();
        
        failed = false;
        try {
            iter.set(VAL_STR + 8);
        } catch (RuntimeStorageException e) {
            failed = true;
        }
        if (!failed)
            fail();
        
        iter.next();
        failed = false;
        try {
            iter.add(VAL_STR + 11);
        } catch (RuntimeStorageException e) {
            failed = true;
        }
        if (!failed)
            fail();
        
    }

}