package org.netbeans.mdr.test;

/*
 * Test.java
 *
 * Created on June 17, 2002, 7:42 PM
 */
import java.util.*;
import org.netbeans.api.mdr.*;
import test.*;
import javax.jmi.reflect.*;
import javax.jmi.model.*;
import junit.extensions.*;
import junit.framework.*;
/**
 *
 * @author  tz97951
 */
public class TransientTest extends MDRTestCase {
    
    private static final int SOFT = 10000;
    private static final int HARD = 1000000;
    
    private static final int SERVICE_COUNT = 1000;
    private static final int SERVICE_COMPONENT_COUNT = 10;
    private static final int COMPONENT_COUNT = 10;
    
    private static final String XMI_FILE_NAME = "transient.xml";
    private static final String MODEL_PKG_NAME = "TransientTestModel";
    private static final String PKG_NAME = "TransientTest";
    private static final String PKG_ELEMENT = "Test";
    
    private TestPackage pkg;
    
    /** Creates a new instance of Test */
    public TransientTest (String testName) {
        super (testName);
    }
    
    /**
     * @param args the command line arguments
     */
    public void test () {
        init ();    
	System.out.println ("INIT DONE");
	try {
            testTxT (this.pkg);
            testTxP (this.pkg);
	}catch (Exception e) {
	    e.printStackTrace (System.out);
	}
    }
    
    private void init () {
        try {
            RefPackage modelPackage = loadMOFModel (XMI_FILE_NAME, MODEL_PKG_NAME);
            RefObject pkgObj = findMofPackage ((ModelPackage)modelPackage, PKG_ELEMENT);
            this.pkg = (TestPackage) this.repository.createExtent (PKG_NAME, pkgObj);
        } catch (Exception e) {
	    e.printStackTrace (System.out);
            fail (e.toString ());
        }
    }
    
    private void testTxP (TestPackage pkg) {
        ServiceClass cls = pkg.getService ();
        Service[] services = new Service [SERVICE_COMPONENT_COUNT];
        for (int i = 0; i< services.length; i++)
            services[i] = pkg.getService().createService ("TPS-"+i);
        Component[] components = new Component [COMPONENT_COUNT];
        for (int i = 0; i< components.length; i++)
            components[i] = pkg.getComponent().createComponent ("Cmp-"+i,1);
        
        for (int i=0; i< components.length; i++) {
            Collection c = components[i].getProvidedService ();
            for (int j=0; j< services.length; j++)
                c.add (services[j]);
        }

        System.out.print ("Verifying component links ...");
        System.out.flush ();
        for (int i=0; i< components.length; i++)
            verifyComponentServiceLinks (components[i], SERVICE_COMPONENT_COUNT, true);
        System.out.println("Done");
        
        System.out.print ("Verifying service links ...");
        System.out.flush ();
        for (int i=0; i< services.length; i++)
            verifyServiceComponentLinks (services[i], COMPONENT_COUNT, true);
        System.out.println("Done");
        
        
        
        for (int i=0; i< services.length; i++) {
            if (i%2 == 0)
                services[i] = null;
        }
        
        free (HARD);
        System.out.println ("Verifying component links after free ...");
        for (int i=0; i< components.length; i++)
            verifyComponentServiceLinks (components[i], SERVICE_COMPONENT_COUNT, false);
        System.out.println("Done");
        
    }
    
    private void testTxT (TestPackage pkg) {
        ServiceClass cls = pkg.getService();
        boolean sct = ((org.netbeans.mdr.storagemodel.StorableClass)((org.netbeans.mdr.handlers.ClassProxyHandler)cls)._getDelegate()).isTransient();
        System.out.println("Service Class Transien ? " + sct);
        if (!sct)
            fail ("Service class was not recognized as transient.");
        Service rootService = cls.createService("RootService");
        Service lastService = rootService;
        for (int i=0; i< SERVICE_COUNT; i++) {
            Service service = cls.createService("Service_"+i);
            pkg.getDelegate().add(lastService, service);
            lastService = service;
        }
        
        free(HARD);
        verifyServiceInstances(cls, SERVICE_COUNT+1, true);
        rootService = null;
        lastService = null;
        free(HARD);
        verifyServiceInstances(cls, SERVICE_COUNT, false);
    }
    
    
    private void free (int count) {
        System.out.print ("FREEING...");
        System.out.flush ();
        System.gc ();
        String[] mem = new String [count];
        for (int i=0; i< count; i++)
            mem[i] = new String (Integer.toString (i));
        System.gc ();
        mem = null;
        System.gc ();
        System.out.println("DONE.");
    }
    
    private static void verifyServiceInstances (ServiceClass cls, int c, boolean eq) {
        int count = 0;
        for (Iterator it = cls.refAllOfType ().iterator(); it.hasNext ();count++) {
            ((Service)it.next()).getName();
        }
        System.out.print ("Service Count = "+count+" should be ");
        if (eq) {
            System.out.print ( "equal to ");
        }
        else {
            System.out.print ("equal or less than ");
        }
        System.out.println (c);
        
        if (eq && c != count)
            fail ("Count assertion failed.");
    }
    
    private static void verifyComponentServiceLinks (Component c, int fc, boolean eq) {
        int count = 0;
        for (Iterator it = c.getProvidedService ().iterator (); it.hasNext (); count++) {
            if (it.next()==null)
                System.out.println("NULL ENTRY");
        }
        System.out.print ("Link Count = "+count+" should be ");
        if (eq) {
            System.out.print ( "equal to ");
        }
        else {
            System.out.print ("equal or less than ");
        }
        System.out.println (fc);
        if (eq && fc != count)
            fail ("Count assertion failed.");
    }
    
    private static void verifyServiceComponentLinks (Service s, int fc, boolean eq) {
        int count = 0;
        for (Iterator it = s.getProvider ().iterator (); it.hasNext (); count++) {
            if (it.next()==null)
                System.out.println("NULL ENTRY");
        }
        System.out.print ("Link Count = "+count+" should be ");
        if (eq) {
            System.out.print ( "equal to ");
        }
        else {
            System.out.print ("equal or less than ");
        }
        System.out.println (fc);
        if (eq && fc != count)
            fail ("Count assertion failed.");
    }
    
    
    
    
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TransientTest.class);
        TestSetup setup = new TestSetup(suite) {
            public void setUp() {
            }
            
            public void tearDown() {
            }
        };
        return setup;
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
}
